/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.validator.parent;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.item.validator.parent.ParentItemValidator;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.util.function.Predicate;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class PathLengthValidator
implements ParentItemValidator,
Ordered {
    private static final int MAX_PATH_LENGTH = 64;

    @Override
    public void validate(StartTestItemRQ rq, TestItem parent) {
        BusinessRule.expect((Object)(parent.getPath().split("\\.").length >= 64 ? 1 : 0), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Exceeded nesting limit for test item. Max limit is 64."});
    }

    public int getOrder() {
        return 4;
    }
}

