/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.AbstractStatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToSkippedStatusChangingStrategy
extends AbstractStatusChangingStrategy {
    public static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    private final ItemAttributeRepository itemAttributeRepository;

    @Autowired
    protected ToSkippedStatusChangingStrategy(TestItemService testItemService, ProjectRepository projectRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, IssueTypeHandler issueTypeHandler, MessageBus messageBus, IssueEntityRepository issueEntityRepository, LogRepository logRepository, LogIndexer logIndexer, ItemAttributeRepository itemAttributeRepository) {
        super(testItemService, projectRepository, launchRepository, testItemRepository, issueTypeHandler, messageBus, issueEntityRepository, logRepository, logIndexer);
        this.itemAttributeRepository = itemAttributeRepository;
    }

    @Override
    protected void updateStatus(Project project, Launch launch, TestItem testItem, StatusEnum providedStatus, ReportPortalUser user, boolean updateParents) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.SKIPPED})).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Incorrect status - '{}', only '{}' is allowed", (Object[])new Object[]{providedStatus, StatusEnum.SKIPPED}).get()});
        testItem.getItemResults().setStatus(providedStatus);
        if (Objects.isNull(testItem.getRetryOf())) {
            boolean issueRequired;
            Optional skippedIssueAttribute = this.itemAttributeRepository.findByLaunchIdAndKeyAndSystem(testItem.getLaunchId(), SKIPPED_ISSUE_KEY, true);
            boolean bl = issueRequired = skippedIssueAttribute.isPresent() && BooleanUtils.toBoolean((String)((ItemAttribute)skippedIssueAttribute.get()).getValue());
            if (issueRequired) {
                if (testItem.getItemResults().getIssue() == null && testItem.isHasStats()) {
                    this.addToInvestigateIssue(testItem, project.getId());
                }
            } else {
                Optional.ofNullable(testItem.getItemResults().getIssue()).map(issue -> {
                    issue.setTestItemResults(null);
                    testItem.getItemResults().setIssue(null);
                    return issue.getIssueId();
                }).ifPresent(arg_0 -> ((IssueEntityRepository)this.issueEntityRepository).deleteById(arg_0));
            }
            ArrayList<Long> itemsToReindex = new ArrayList<Long>();
            if (updateParents) {
                itemsToReindex = this.changeParentsStatuses(testItem, launch, true, user);
            }
            itemsToReindex.add(testItem.getItemId());
            this.logIndexer.indexItemsRemove(project.getId(), itemsToReindex);
            if (!issueRequired) {
                itemsToReindex.remove(itemsToReindex.size() - 1);
            }
            this.logIndexer.indexItemsLogs(project.getId(), launch.getId(), itemsToReindex, AnalyzerUtils.getAnalyzerConfig(project));
        }
    }

    @Override
    protected StatusEnum evaluateParentItemStatus(TestItem parentItem, TestItem childItem) {
        return StatusEnum.FAILED;
    }
}

