/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.util.ControllerUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MaterializedWidgetProviderHandlerImpl
implements DataProviderHandler {
    private static final String WIDGET_ID_PARAM = "widgetId";
    @Autowired
    private Map<WidgetType, DataProviderHandler> testItemWidgetDataProviders;
    @Autowired
    private WidgetRepository widgetRepository;

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> providerParams) {
        WidgetType widgetType = this.updateProviderParams(projectDetails, providerParams);
        return this.testItemWidgetDataProviders.get(widgetType).getTestItems(filter, pageable, projectDetails, user, providerParams);
    }

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> providerParams) {
        WidgetType widgetType = this.updateProviderParams(projectDetails, providerParams);
        return this.testItemWidgetDataProviders.get(widgetType).accumulateStatistics(filter, projectDetails, user, providerParams);
    }

    private WidgetType updateProviderParams(ReportPortalUser.ProjectDetails projectDetails, Map<String, String> providerParams) {
        Long widgetId = Optional.ofNullable(providerParams.get(WIDGET_ID_PARAM)).map(ControllerUtils::safeParseLong).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Widget id must be provided for widget based items provider"}));
        Widget widget = (Widget)this.widgetRepository.findByIdAndProjectId(widgetId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{widgetId, projectDetails.getProjectName()}));
        this.validateState(widget.getWidgetOptions());
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        providerParams.put("viewName", widget.getWidgetOptions().getOptions().get("viewName").toString());
        return widgetType;
    }

    private void validateState(WidgetOptions widgetOptions) {
        WidgetState widgetState = (WidgetState)Optional.ofNullable(WidgetOptionUtil.getValueByKey("state", widgetOptions)).flatMap(WidgetState::findByName).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_UPDATE_WIDGET_REQUEST, new Object[]{"Widget state not provided"}));
        BusinessRule.expect((Object)widgetState, it -> !WidgetState.RENDERING.equals(it)).verify(ErrorType.BAD_UPDATE_WIDGET_REQUEST, new Object[]{"Unable to remove widget in 'rendering' state"});
    }
}

