/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.impl.filter.updater.FilterUpdater;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.util.ControllerUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class LaunchDataProviderHandlerImpl
implements DataProviderHandler {
    private static final String LAUNCH_ID_PARAM = "launchId";
    @Autowired
    private LaunchAccessValidator launchAccessValidator;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private FilterUpdater filterUpdater;

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        filter = this.updateFilter(filter, projectDetails, user, params);
        return this.testItemRepository.findByFilter(filter, pageable);
    }

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        filter = this.updateFilter(filter, projectDetails, user, params);
        return this.testItemRepository.accumulateStatisticsByFilter(filter);
    }

    private Queryable updateFilter(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        Long launchId = Optional.ofNullable(params.get(LAUNCH_ID_PARAM)).map(ControllerUtils::safeParseLong).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch id must be provided for launch based items provider"}));
        this.launchAccessValidator.validate(launchId, projectDetails, user);
        Filter launchBasedFilter = Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq(LAUNCH_ID_PARAM, String.valueOf(launchId)).build()).build();
        this.filterUpdater.update(filter);
        return new CompositeFilter(Operator.AND, new Queryable[]{filter, launchBasedFilter});
    }
}

