/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class DelegatingClusterDataProviderHandler
implements DataProviderHandler {
    public static final String CLUSTER_ID_PARAM = "clusterId";
    private final Integer maxPageSize;
    private final DataProviderHandler delegate;

    public DelegatingClusterDataProviderHandler(Integer maxPageSize, DataProviderHandler dataProviderHandler) {
        this.maxPageSize = maxPageSize;
        this.delegate = dataProviderHandler;
    }

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        this.validateClusterCondition(filter);
        this.validatePageSize(pageable);
        return this.delegate.getTestItems(filter, pageable, projectDetails, user, params);
    }

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        this.validateClusterCondition(filter);
        return this.delegate.accumulateStatistics(filter, projectDetails, user, params);
    }

    private void validateClusterCondition(Queryable filter) {
        boolean hasClusterIdCondition = filter.getFilterConditions().stream().flatMap(c -> c.getAllConditions().stream()).anyMatch(c -> c.getSearchCriteria().contains(CLUSTER_ID_PARAM));
        BusinessRule.expect((Object)hasClusterIdCondition, BooleanUtils::isTrue).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Cluster id condition not provided"});
    }

    private void validatePageSize(Pageable pageable) {
        BusinessRule.expect((Object)pageable.getPageSize(), pageSize -> pageSize <= this.maxPageSize).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Max page size: " + this.maxPageSize});
    }
}

