/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider;

import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderType;
import com.epam.ta.reportportal.core.item.impl.provider.FilterDataProviderImpl;
import com.epam.ta.reportportal.core.item.impl.provider.impl.BaselineLaunchDataProvider;
import com.epam.ta.reportportal.core.item.impl.provider.impl.CumulativeTestItemDataProviderImpl;
import com.epam.ta.reportportal.core.item.impl.provider.impl.DelegatingClusterDataProviderHandler;
import com.epam.ta.reportportal.core.item.impl.provider.impl.LaunchDataProviderHandlerImpl;
import com.epam.ta.reportportal.core.item.impl.provider.impl.MaterializedWidgetProviderHandlerImpl;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProviderTypeConfig {
    private ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public DelegatingClusterDataProviderHandler delegatingClusterDataProviderHandler(@Value(value="${rp.environment.variable.cluster.item.page-size}") Integer maxPageSize, @Autowired LaunchDataProviderHandlerImpl launchDataProviderHandler) {
        return new DelegatingClusterDataProviderHandler(maxPageSize, launchDataProviderHandler);
    }

    @Bean(value={"testItemDataProviders"})
    public Map<DataProviderType, DataProviderHandler> testItemDataProviders() {
        return ImmutableMap.builder().put((Object)DataProviderType.WIDGET_BASED, (Object)((DataProviderHandler)this.applicationContext.getBean(MaterializedWidgetProviderHandlerImpl.class))).put((Object)DataProviderType.LAUNCH_BASED, (Object)((DataProviderHandler)this.applicationContext.getBean(LaunchDataProviderHandlerImpl.class))).put((Object)DataProviderType.FILTER_BASED, (Object)((DataProviderHandler)this.applicationContext.getBean(FilterDataProviderImpl.class))).put((Object)DataProviderType.CLUSTER_BASED, (Object)((DataProviderHandler)this.applicationContext.getBean(DelegatingClusterDataProviderHandler.class))).put((Object)DataProviderType.BASELINE_BASED, (Object)((DataProviderHandler)this.applicationContext.getBean(BaselineLaunchDataProvider.class))).build();
    }

    @Bean(value={"testItemWidgetDataProviders"})
    public Map<WidgetType, DataProviderHandler> testItemWidgetDataProviders() {
        return ImmutableMap.builder().put((Object)WidgetType.CUMULATIVE, (Object)((DataProviderHandler)this.applicationContext.getBean(CumulativeTestItemDataProviderImpl.class))).build();
    }
}

