/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history;

import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;

public enum ItemHistoryBaselineEnum {
    COMPARING(1, historyRequestParams -> historyRequestParams.getHistoryType().map(HistoryRequestParams.HistoryTypeEnum.COMPARING::equals).orElse(Boolean.FALSE)),
    FILTER(2, historyRequestParams -> historyRequestParams.getFilterParams().isPresent()),
    ITEM(3, historyRequestParams -> historyRequestParams.getParentId().isPresent() || historyRequestParams.getItemId().isPresent()),
    LAUNCH(4, historyRequestParams -> historyRequestParams.getLaunchId().isPresent());

    private final int priority;
    private final Predicate<HistoryRequestParams> baseLinePredicate;

    public static Optional<ItemHistoryBaselineEnum> resolveType(HistoryRequestParams historyRequestParams) {
        return Arrays.stream(ItemHistoryBaselineEnum.values()).sorted(Comparator.comparingInt(ItemHistoryBaselineEnum::getPriority)).filter(v -> v.getBaseLinePredicate().test(historyRequestParams)).findFirst();
    }

    private ItemHistoryBaselineEnum(int priority, Predicate<HistoryRequestParams> baseLinePredicate) {
        this.priority = priority;
        this.baseLinePredicate = baseLinePredicate;
    }

    public int getPriority() {
        return this.priority;
    }

    public Predicate<HistoryRequestParams> getBaseLinePredicate() {
        return this.baseLinePredicate;
    }
}

