/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdaterProvider;
import com.epam.ta.reportportal.ws.converter.utils.item.content.TestItemUpdaterContent;
import com.epam.ta.reportportal.ws.reporting.TestItemResource;
import jakarta.persistence.QueryTimeoutException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TestCaseSearchHandler {
    private final TestItemRepository testItemRepository;
    private final List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders;

    public Page<TestItemResource> searchTestItems(String namePart, String attribute, String statuses, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails) {
        Slice<TestItem> result;
        pageable = this.validateInputParameters(namePart, attribute, pageable);
        try {
            result = StringUtils.hasText((String)attribute) ? this.searchByAttribute(attribute, statuses, pageable, projectDetails) : this.searchByName(namePart, statuses, pageable, projectDetails);
        }
        catch (QueryTimeoutException e) {
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Please refine your search by providing a more specific or unique test case name / attribute."});
        }
        List<ResourceUpdater<TestItemResource>> resourceUpdaters = this.getResourceUpdaters(projectDetails.getProjectId(), result.getContent());
        return new Page<TestItemResource>(result.stream().map(item -> {
            TestItemResource testItemResource = TestItemConverter.TO_RESOURCE.apply((TestItem)item);
            resourceUpdaters.forEach(updater -> updater.updateResource(testItemResource));
            return testItemResource;
        }).collect(Collectors.toList()), new Page.PageMetadata((Integer)(result.getPageable().getPageNumber() + 1), (Integer)result.getPageable().getPageSize(), result.hasNext()));
    }

    private Slice<TestItem> searchByName(String namePart, String statuses, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails) {
        if (StringUtils.hasText((String)statuses)) {
            return this.testItemRepository.findTestItemsContainsNameAndStatuses(namePart, projectDetails.getProjectId(), this.parseStatuses(statuses), pageable);
        }
        return this.testItemRepository.findTestItemsContainsName(namePart, projectDetails.getProjectId(), pageable);
    }

    private Slice<TestItem> searchByAttribute(String attribute, String statuses, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails) {
        if (attribute.contains(":")) {
            String[] attributeSplit = attribute.split(":");
            if (StringUtils.hasText((String)statuses)) {
                return this.testItemRepository.findTestItemsByAttributeAndStatuses(projectDetails.getProjectId(), attributeSplit[0], attributeSplit[1], this.parseStatuses(statuses), pageable);
            }
            return this.testItemRepository.findTestItemsByAttribute(projectDetails.getProjectId(), attributeSplit[0], attributeSplit[1], pageable);
        }
        if (StringUtils.hasText((String)statuses)) {
            return this.testItemRepository.findTestItemsByAttributeAndStatuses(projectDetails.getProjectId(), attribute, this.parseStatuses(statuses), pageable);
        }
        return this.testItemRepository.findTestItemsByAttribute(projectDetails.getProjectId(), attribute, pageable);
    }

    private List<String> parseStatuses(String statuses) {
        return Arrays.stream(statuses.split(",")).filter(StatusEnum::isPresent).collect(Collectors.toList());
    }

    private Pageable validateInputParameters(String namePart, String attribute, Pageable pageable) {
        if (0 == pageable.getPageSize() || 10 < pageable.getPageSize()) {
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)10, (Sort)pageable.getSort());
        }
        if (pageable.getOffset() > 300L) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Total amount must be lower or equals than 300"});
        }
        if (!StringUtils.hasText((String)namePart) && !StringUtils.hasText((String)attribute)) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Provide either 'filter.has.compositeAttribute' or 'filter.cnt.name'."});
        }
        if (StringUtils.hasText((String)namePart) && namePart.length() < 3) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Value of 'filter.cnt.name' must contains more than 2 symbols."});
        }
        return pageable;
    }

    private List<ResourceUpdater<TestItemResource>> getResourceUpdaters(Long projectId, List<TestItem> testItems) {
        return this.resourceUpdaterProviders.stream().map(retriever -> retriever.retrieve(TestItemUpdaterContent.of(projectId, testItems))).collect(Collectors.toList());
    }

    @Generated
    public TestCaseSearchHandler(TestItemRepository testItemRepository, List<ResourceUpdaterProvider<TestItemUpdaterContent, TestItemResource>> resourceUpdaterProviders) {
        this.testItemRepository = testItemRepository;
        this.resourceUpdaterProviders = resourceUpdaterProviders;
    }
}

