/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.identity.IdentityUtil;
import com.epam.ta.reportportal.core.item.identity.TestCaseHashGenerator;
import com.epam.ta.reportportal.core.item.identity.UniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.retry.RetryHandler;
import com.epam.ta.reportportal.core.item.impl.retry.RetrySearcher;
import com.epam.ta.reportportal.core.item.validator.parent.ParentItemValidator;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.reporting.ItemCreatedRS;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
class StartTestItemHandlerImpl
implements StartTestItemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestItemHandlerImpl.class);
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final UniqueIdGenerator uniqueIdGenerator;
    private final TestCaseHashGenerator testCaseHashGenerator;
    private final RerunHandler rerunHandler;
    private final List<ParentItemValidator> parentItemValidators;
    private final RetrySearcher retrySearcher;
    private final RetryHandler retryHandler;

    @Autowired
    public StartTestItemHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository, UniqueIdGenerator uniqueIdGenerator, TestCaseHashGenerator testCaseHashGenerator, RerunHandler rerunHandler, List<ParentItemValidator> parentItemValidators, @Qualifier(value="uniqueIdRetrySearcher") RetrySearcher retrySearcher, RetryHandler retryHandler) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.uniqueIdGenerator = uniqueIdGenerator;
        this.testCaseHashGenerator = testCaseHashGenerator;
        this.rerunHandler = rerunHandler;
        this.parentItemValidators = parentItemValidators;
        this.retrySearcher = retrySearcher;
        this.retryHandler = retryHandler;
    }

    @Override
    public ItemCreatedRS startRootItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq) {
        Optional<ItemCreatedRS> rerunCreatedRs;
        Launch launch = (Launch)this.launchRepository.findByUuid(rq.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchUuid()}));
        this.validate(user, projectDetails, rq, launch);
        if (launch.isRerun() && (rerunCreatedRs = this.rerunHandler.handleRootItem(rq, launch)).isPresent()) {
            return rerunCreatedRs.get();
        }
        TestItem item = new TestItemBuilder().addStartItemRequest(rq).addAttributes(rq.getAttributes()).addLaunchId(launch.getId()).get();
        this.testItemRepository.save((Object)item);
        this.generateUniqueId(launch, item, String.valueOf(item.getItemId()));
        LOGGER.debug("Created new root TestItem {}", (Object)item.getUuid());
        return new ItemCreatedRS(item.getUuid(), item.getUniqueId());
    }

    @Override
    public ItemCreatedRS startChildItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq, String parentId) {
        TestItem parentItem;
        Optional<ItemCreatedRS> rerunCreatedRs;
        boolean isRetry = BooleanUtils.toBoolean((Boolean)rq.getRetry()) || StringUtils.isNotBlank((CharSequence)rq.getRetryOf());
        Launch launch = (Launch)this.launchRepository.findByUuid(rq.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchUuid()}));
        if (launch.isRerun() && (rerunCreatedRs = this.rerunHandler.handleChildItem(rq, launch, parentId)).isPresent()) {
            return rerunCreatedRs.get();
        }
        if (isRetry) {
            Long lockedParentId = (Long)this.testItemRepository.findIdByUuidForUpdate(parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
            parentItem = (TestItem)this.testItemRepository.getOne((Object)lockedParentId);
        } else {
            parentItem = (TestItem)this.testItemRepository.findByUuid(parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        }
        this.parentItemValidators.forEach(v -> v.validate(rq, parentItem));
        TestItem item = new TestItemBuilder().addStartItemRequest(rq).addAttributes(rq.getAttributes()).addLaunchId(launch.getId()).get();
        if (isRetry) {
            this.processRetry(rq, launch, item, parentItem);
        } else {
            this.saveChildItem(launch, item, parentItem);
        }
        LOGGER.debug("Created new child TestItem {} with root {}", (Object)item.getUuid(), (Object)parentId);
        if (rq.isHasStats() && !parentItem.isHasChildren()) {
            parentItem.setHasChildren(true);
        }
        return new ItemCreatedRS(item.getUuid(), item.getUniqueId());
    }

    private void processRetry(StartTestItemRQ rq, Launch launch, TestItem item, TestItem parentItem) {
        Long retryParentId = Optional.ofNullable(rq.getRetryOf()).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findIdByUuidForUpdate(arg_0)).orElseGet(() -> this.retrySearcher.findPreviousRetry(launch, item, parentItem).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{item.getUniqueId()})));
        this.saveChildItem(launch, item, parentItem);
        this.retryHandler.handleRetries(launch, item, retryParentId);
    }

    private TestItem saveChildItem(Launch launch, TestItem childItem, TestItem parentItem) {
        childItem.setParentId(parentItem.getItemId());
        this.testItemRepository.save((Object)childItem);
        this.generateUniqueId(launch, childItem, parentItem.getPath() + "." + childItem.getItemId());
        return childItem;
    }

    private void generateUniqueId(Launch launch, TestItem item, String path) {
        item.setPath(path);
        if (Objects.isNull(item.getUniqueId())) {
            item.setUniqueId(this.uniqueIdGenerator.generate(item, IdentityUtil.getParentIds(item), launch));
        }
        if (Objects.isNull(item.getTestCaseId())) {
            item.setTestCaseHash(this.testCaseHashGenerator.generate(item, IdentityUtil.getParentIds(item), launch.getProjectId()));
        }
    }

    private void validate(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq, Launch launch) {
        if (!UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            BusinessRule.expect((Object)projectDetails.getProjectId(), (Predicate)Predicates.equalTo((Object)launch.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        BusinessRule.expect((Object)rq.getStartTime(), (Predicate)Preconditions.sameTimeOrLater((Instant)launch.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), launch.getStartTime(), launch.getId()});
        BusinessRule.expect((Object)BooleanUtils.isTrue((Boolean)BooleanUtils.toBoolean((Boolean)rq.getRetry())), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Root test item can't be a retry."});
    }
}

