/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.core.item.ExternalTicketHandler;
import com.epam.ta.reportportal.dao.TicketRepository;
import com.epam.ta.reportportal.entity.bts.Ticket;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.model.item.UnlinkExternalIssueRQ;
import com.epam.ta.reportportal.ws.converter.converters.TicketConverter;
import com.epam.ta.reportportal.ws.reporting.Issue;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalTicketHandlerImpl
implements ExternalTicketHandler {
    @Autowired
    private TicketRepository ticketRepository;

    @Override
    public void linkExternalTickets(String submitter, List<IssueEntity> issueEntities, List<Issue.ExternalSystemIssue> tickets) {
        List<Ticket> existedTickets = this.collectExistedTickets(tickets);
        Set<Ticket> ticketsFromRq = this.collectTickets(tickets, submitter);
        this.linkTickets(issueEntities, existedTickets, ticketsFromRq);
    }

    @Override
    public void unlinkExternalTickets(List<TestItem> items, UnlinkExternalIssueRQ request) {
        items.forEach(testItem -> {
            IssueEntity issue = testItem.getItemResults().getIssue();
            if (issue.getTickets().removeIf(it -> request.getTicketIds().contains(it.getTicketId()))) {
                issue.setAutoAnalyzed(Boolean.valueOf(false));
            }
        });
    }

    @Override
    public void updateLinking(String submitter, IssueEntity issueEntity, Set<Issue.ExternalSystemIssue> externalTickets) {
        Optional.ofNullable(externalTickets).ifPresent(tickets -> {
            Set<Ticket> existedTickets = this.collectTickets((Collection<Issue.ExternalSystemIssue>)tickets, submitter);
            issueEntity.getTickets().removeIf(it -> !existedTickets.contains(it));
            issueEntity.getTickets().addAll(existedTickets);
            existedTickets.stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getIssues())).forEach(it -> it.getIssues().add(issueEntity));
        });
    }

    private List<Ticket> collectExistedTickets(Collection<Issue.ExternalSystemIssue> externalIssues) {
        if (CollectionUtils.isEmpty(externalIssues)) {
            return Collections.emptyList();
        }
        List existedTickets = this.ticketRepository.findByTicketIdIn(externalIssues.stream().map(Issue.ExternalSystemIssue::getTicketId).collect(Collectors.toList()));
        List existedTicketsIds = existedTickets.stream().map(Ticket::getTicketId).collect(Collectors.toList());
        externalIssues.removeIf(it -> existedTicketsIds.contains(it.getTicketId()));
        return existedTickets;
    }

    private Set<Ticket> collectTickets(Collection<Issue.ExternalSystemIssue> externalIssues, String username) {
        if (CollectionUtils.isEmpty(externalIssues)) {
            return Collections.emptySet();
        }
        return externalIssues.stream().map(it -> {
            Ticket ticket;
            Optional ticketOptional = this.ticketRepository.findByTicketIdAndBtsProject(it.getTicketId(), it.getBtsProject());
            if (ticketOptional.isPresent()) {
                ticket = (Ticket)ticketOptional.get();
                ticket.setUrl(it.getUrl());
                ticket.setBtsProject(it.getBtsProject());
                ticket.setBtsUrl(it.getBtsUrl());
                ticket.setPluginName(it.getPluginName());
            } else {
                ticket = TicketConverter.TO_TICKET.apply((Issue.ExternalSystemIssue)it);
            }
            ticket.setSubmitter(username);
            ticket.setSubmitDate(Optional.ofNullable(it.getSubmitDate()).orElse(Instant.now()));
            return ticket;
        }).collect(Collectors.toSet());
    }

    private void linkTickets(List<IssueEntity> issueEntities, List<Ticket> existedTickets, Set<Ticket> ticketsFromRq) {
        List tickets = this.ticketRepository.saveAll(ticketsFromRq);
        issueEntities.forEach(entity -> {
            entity.getTickets().addAll(existedTickets);
            entity.getTickets().addAll(tickets);
            entity.setAutoAnalyzed(Boolean.valueOf(false));
        });
    }
}

