/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.reportportal.events.ElementsDeletedEvent;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.ElementsCounterService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteTestItemHandlerImpl
implements DeleteTestItemHandler {
    private final TestItemRepository testItemRepository;
    private final ContentRemover<Long> itemContentRemover;
    private final LogIndexer logIndexer;
    private final LaunchRepository launchRepository;
    private final AttachmentRepository attachmentRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final ElementsCounterService elementsCounterService;
    private final LogService logService;
    private static final Function<Long, OperationCompletionRS> COMPOSE_DELETE_RESPONSE = it -> {
        String message = (String)Suppliers.formattedSupplier((String)"Test Item with ID = '{}' has been successfully deleted.", (Object[])new Object[]{it}).get();
        return new OperationCompletionRS(message);
    };

    @Autowired
    public DeleteTestItemHandlerImpl(TestItemRepository testItemRepository, ContentRemover<Long> itemContentRemover, LogIndexer logIndexer, LaunchRepository launchRepository, AttachmentRepository attachmentRepository, ApplicationEventPublisher eventPublisher, ElementsCounterService elementsCounterService, LogService logService) {
        this.testItemRepository = testItemRepository;
        this.itemContentRemover = itemContentRemover;
        this.logIndexer = logIndexer;
        this.launchRepository = launchRepository;
        this.attachmentRepository = attachmentRepository;
        this.eventPublisher = eventPublisher;
        this.elementsCounterService = elementsCounterService;
        this.logService = logService;
    }

    @Override
    public OperationCompletionRS deleteTestItem(Long itemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        TestItem item = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
        this.validate(item, launch, user, projectDetails);
        Optional<Long> parentId = Optional.ofNullable(item.getParentId());
        HashSet itemsForRemove = Sets.newHashSet((Iterable)this.testItemRepository.selectAllDescendantsIds(item.getPath()));
        itemsForRemove.forEach(this.itemContentRemover::remove);
        this.eventPublisher.publishEvent((ApplicationEvent)new ElementsDeletedEvent((Object)item, projectDetails.getProjectId(), this.elementsCounterService.countNumberOfItemElements(item).longValue()));
        this.logService.deleteLogMessageByTestItemSet(projectDetails.getProjectId(), itemsForRemove);
        this.itemContentRemover.remove(item.getItemId());
        this.testItemRepository.deleteById((Object)item.getItemId());
        launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        parentId.flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findById(arg_0)).ifPresent(p -> p.setHasChildren(this.testItemRepository.hasChildren(p.getItemId(), p.getPath())));
        this.logIndexer.indexItemsRemoveAsync(projectDetails.getProjectId(), itemsForRemove);
        this.attachmentRepository.moveForDeletionByItems((Collection)itemsForRemove);
        return COMPOSE_DELETE_RESPONSE.apply(item.getItemId());
    }

    @Override
    public List<OperationCompletionRS> deleteTestItems(Collection<Long> ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List items = this.testItemRepository.findAllById(ids);
        List launches = this.launchRepository.findAllById((Iterable)items.stream().map(TestItem::getLaunchId).filter(Objects::nonNull).collect(Collectors.toSet()));
        Map<Long, List<TestItem>> launchItemMap = items.stream().collect(Collectors.groupingBy(TestItem::getLaunchId));
        launches.forEach(launch -> ((List)launchItemMap.get(launch.getId())).forEach(item -> this.validate((TestItem)item, (Launch)launch, user, projectDetails)));
        Map descendantsMapping = this.testItemRepository.selectPathNames((Collection)items);
        HashSet idsToDelete = Sets.newHashSet(descendantsMapping.keySet());
        descendantsMapping.forEach((key, value) -> value.getItemPaths().forEach(ip -> {
            if (idsToDelete.contains(ip.getId())) {
                idsToDelete.remove(key);
            }
        }));
        List parentsToUpdate = this.testItemRepository.findAllById((Iterable)items.stream().filter(it -> idsToDelete.contains(it.getItemId())).map(TestItem::getParentId).filter(Objects::nonNull).collect(Collectors.toList()));
        Set<Long> removedItems = this.testItemRepository.findAllById((Iterable)idsToDelete).stream().map(TestItem::getPath).collect(Collectors.toList()).stream().flatMap(path -> this.testItemRepository.selectAllDescendantsIds(path).stream()).collect(Collectors.toSet());
        idsToDelete.forEach(this.itemContentRemover::remove);
        this.eventPublisher.publishEvent((ApplicationEvent)new ElementsDeletedEvent((Object)items, projectDetails.getProjectId(), this.elementsCounterService.countNumberOfItemElements(items).longValue()));
        this.logService.deleteLogMessageByTestItemSet(projectDetails.getProjectId(), removedItems);
        this.testItemRepository.deleteAllByItemIdIn((Collection)idsToDelete);
        launches.forEach(it -> it.setHasRetries(this.launchRepository.hasRetries(it.getId())));
        parentsToUpdate.forEach(it -> it.setHasChildren(this.testItemRepository.hasChildren(it.getItemId(), it.getPath())));
        if (CollectionUtils.isNotEmpty(removedItems)) {
            this.logIndexer.indexItemsRemoveAsync(projectDetails.getProjectId(), removedItems);
            this.attachmentRepository.moveForDeletionByItems(removedItems);
        }
        return idsToDelete.stream().map(COMPOSE_DELETE_RESPONSE).collect(Collectors.toList());
    }

    private void validate(TestItem testItem, Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Deleting testItem '{}' is not under specified project '{}'", (Object[])new Object[]{testItem.getItemId(), projectDetails.getProjectId()})});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not a launch owner."});
            }
        }
        BusinessRule.expect((Object)testItem.getRetryOf(), Objects::isNull).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] because it is a retry", (Object[])new Object[]{testItem.getItemId()}).get()});
        BusinessRule.expect((Object)testItem.getItemResults().getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] in progress state", (Object[])new Object[]{testItem.getItemId()})});
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] under launch ['{}'] with 'In progress' state", (Object[])new Object[]{testItem.getItemId(), launch.getId()})});
    }
}

