/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.CriteriaHolder;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.FilterCreatedEvent;
import com.epam.ta.reportportal.core.events.activity.FilterUpdatedEvent;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.model.CollectionsRQ;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.activity.UserFilterActivityResource;
import com.epam.ta.reportportal.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.builders.UserFilterBuilder;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateUserFilterHandlerImpl
implements UpdateUserFilterHandler {
    private static final String KEY_AND_VALUE_DELIMITER = ":";
    private static final String ATTRIBUTES_DELIMITER = ",";
    private final ProjectExtractor projectExtractor;
    private final UserFilterRepository userFilterRepository;
    private final MessageBus messageBus;

    @Autowired
    public UpdateUserFilterHandlerImpl(ProjectExtractor projectExtractor, UserFilterRepository userFilterRepository, MessageBus messageBus) {
        this.projectExtractor = projectExtractor;
        this.userFilterRepository = userFilterRepository;
        this.messageBus = messageBus;
    }

    @Override
    public EntryCreatedRS createFilter(UpdateUserFilterRQ createFilterRQ, String projectName, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
        this.validateFilterRq(createFilterRQ);
        BusinessRule.expect((Object)this.userFilterRepository.existsByNameAndProjectId(createFilterRQ.getName(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{createFilterRQ.getName(), user.getUsername(), projectName});
        UserFilter filter = new UserFilterBuilder().addFilterRq(createFilterRQ).addProject(projectDetails.getProjectId()).addOwner(user.getUsername()).get();
        this.userFilterRepository.save((Object)filter);
        this.messageBus.publishActivity(new FilterCreatedEvent(UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(filter), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(filter.getId());
    }

    @Override
    public EntryCreatedRS createFilterCopyOnDuplicate(UpdateUserFilterRQ createFilterRQ, String projectName, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
        this.validateFilterRq(createFilterRQ);
        this.validateFilterName(createFilterRQ, projectDetails.getProjectId());
        UserFilter filter = new UserFilterBuilder().addFilterRq(createFilterRQ).addProject(projectDetails.getProjectId()).addOwner(user.getUsername()).get();
        this.userFilterRepository.save((Object)filter);
        this.messageBus.publishActivity(new FilterCreatedEvent(UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(filter), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(filter.getId());
    }

    @Override
    public OperationCompletionRS updateUserFilter(Long userFilterId, UpdateUserFilterRQ updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        this.validateFilterRq(updateRQ);
        UserFilter userFilter = (UserFilter)this.userFilterRepository.findByIdAndProjectId(userFilterId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{userFilterId, projectDetails.getProjectName()}));
        BusinessRule.expect((Object)userFilter.getProject().getId(), Predicate.isEqual(projectDetails.getProjectId())).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{userFilterId, projectDetails.getProjectId(), user.getUserId()});
        if (!userFilter.getName().equals(updateRQ.getName())) {
            BusinessRule.expect((Object)this.userFilterRepository.existsByNameAndProjectId(updateRQ.getName(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{updateRQ.getName(), userFilter.getOwner(), projectDetails.getProjectName()});
        }
        UserFilterActivityResource before = UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(userFilter);
        UserFilter updated = new UserFilterBuilder(userFilter).addFilterRq(updateRQ).get();
        this.messageBus.publishActivity(new FilterUpdatedEvent(before, UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(updated), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("User filter with ID = '" + updated.getId() + "' successfully updated.");
    }

    @Override
    public List<OperationCompletionRS> updateUserFilter(CollectionsRQ<BulkUpdateFilterRQ> updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void validateFilterRq(UpdateUserFilterRQ updateFilerRq) {
        FilterTarget filterTarget = FilterTarget.findByClass((Class)ObjectType.getObjectTypeByName((String)updateFilerRq.getObjectType()).getClassObject());
        BusinessRule.expect(updateFilerRq.getConditions(), (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter conditions should not be empty"});
        BusinessRule.expect(updateFilerRq.getOrders(), (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Sort conditions should not be empty"});
        updateFilerRq.getConditions().forEach(it -> {
            CriteriaHolder criteriaHolder = (CriteriaHolder)filterTarget.getCriteriaByFilter(it.getFilteringField()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Filter parameter '{}' is not defined", (Object[])new Object[]{it.getFilteringField()}).get()}));
            Condition condition = (Condition)Condition.findByMarker((String)it.getCondition()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{it.getCondition()}));
            boolean isNegative = Condition.isNegative((String)it.getCondition());
            String value = this.cutAttributesToMaxLength(it.getValue());
            condition.validate(criteriaHolder, value, isNegative, ErrorType.INCORRECT_FILTER_PARAMETERS);
            condition.castValue(criteriaHolder, value, ErrorType.INCORRECT_FILTER_PARAMETERS);
            it.setValue(value);
        });
        updateFilerRq.getOrders().forEach(order -> BusinessRule.expect((Object)filterTarget.getCriteriaByFilter(order.getSortingColumnName()), Optional::isPresent).verify(ErrorType.INCORRECT_SORTING_PARAMETERS, new Object[]{"Unable to find sort parameter '" + order.getSortingColumnName() + "'"}));
    }

    private void validateFilterName(UpdateUserFilterRQ createFilterRQ, Long projectId) {
        IntStream.range(0, 100).takeWhile(i -> this.userFilterRepository.existsByNameAndProjectId(createFilterRQ.getName(), projectId)).forEach(i -> createFilterRQ.setName(createFilterRQ.getName() + "_copy"));
    }

    private String cutAttributesToMaxLength(String keyAndValue) {
        if (keyAndValue == null || keyAndValue.isEmpty()) {
            return keyAndValue;
        }
        String[] attributeArray = keyAndValue.split(ATTRIBUTES_DELIMITER);
        if (attributeArray.length == 0) {
            return this.cutAttributeToLength(keyAndValue, 512);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < attributeArray.length; ++i) {
            String attribute = attributeArray[i];
            attribute = this.cutAttributeToLength(attribute, 512);
            result.append(attribute);
            if (i == attributeArray.length - 1) continue;
            result.append(ATTRIBUTES_DELIMITER);
        }
        return result.toString();
    }

    private String cutAttributeToLength(String attribute, int length) {
        String[] keyAndValueArray = ((String)attribute).split(KEY_AND_VALUE_DELIMITER);
        if (keyAndValueArray.length == 0) {
            attribute = this.cutStringToLength((String)attribute, length);
        } else if (keyAndValueArray.length == 1) {
            attribute = ((String)attribute).contains(KEY_AND_VALUE_DELIMITER) ? this.cutStringToLength(keyAndValueArray[0], length) + KEY_AND_VALUE_DELIMITER : this.cutStringToLength((String)attribute, length);
        } else {
            String key = this.cutStringToLength(keyAndValueArray[0], length);
            String value = this.cutStringToLength(keyAndValueArray[1], length);
            attribute = key + KEY_AND_VALUE_DELIMITER + value;
        }
        return attribute;
    }

    private String cutStringToLength(String string, int length) {
        if (string.length() > length) {
            string = string.substring(0, length);
        }
        return string;
    }
}

