/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.file;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.attachment.DeleteAttachmentEvent;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.api.client.util.Lists;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DeleteFilesHandler {
    private static final int FILE_ID = 1;
    private static final int CSV_SKIP_LINES = 1;
    private static final int THUMBNAIL_ID = 2;
    private static final int BATCH = 250;
    @Autowired
    private MessageBus messageBus;

    public OperationCompletionRS removeFilesByCsv(MultipartFile file) {
        OperationCompletionRS operationCompletionRS;
        block8: {
            CSVParser parser = new CSVParserBuilder().withSeparator(',').withIgnoreQuotations(true).build();
            CSVReader csvReader = new CSVReaderBuilder((Reader)new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8)).withSkipLines(1).withCSVParser((ICSVParser)parser).build();
            try {
                List attachments = csvReader.readAll();
                ArrayList pathsForDelete = Lists.newArrayListWithCapacity((int)attachments.size());
                attachments.forEach(attachmentLine -> {
                    pathsForDelete.add(attachmentLine[1]);
                    if (!StringUtils.isEmpty((CharSequence)attachmentLine[2])) {
                        pathsForDelete.add(attachmentLine[2]);
                    }
                });
                ListUtils.partition((List)pathsForDelete, (int)250).forEach(partition -> {
                    DeleteAttachmentEvent deleteAttachmentEvent = new DeleteAttachmentEvent();
                    deleteAttachmentEvent.setPaths((List<String>)partition);
                    this.messageBus.publish("attachment", "attachment.delete", deleteAttachmentEvent);
                });
                operationCompletionRS = new OperationCompletionRS("Csv file " + file.getName() + " is accepted for delete process");
                if (csvReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (csvReader != null) {
                        try {
                            csvReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{e.getMessage()});
                }
            }
            csvReader.close();
        }
        return operationCompletionRS;
    }
}

