/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.listener;

import com.epam.reportportal.extension.event.LaunchStartUniqueErrorAnalysisEvent;
import com.epam.ta.reportportal.core.launch.cluster.UniqueErrorAnalysisStarter;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.project.config.ProjectConfigProvider;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class StartLaunchUniqueErrorAnalysisEventListener {
    private final ProjectConfigProvider projectConfigProvider;
    private final UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter;

    @Autowired
    public StartLaunchUniqueErrorAnalysisEventListener(ProjectConfigProvider projectConfigProvider, @Qualifier(value="uniqueErrorAnalysisStarter") UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter) {
        this.projectConfigProvider = projectConfigProvider;
        this.uniqueErrorAnalysisStarter = uniqueErrorAnalysisStarter;
    }

    @EventListener
    public void onApplicationEvent(LaunchStartUniqueErrorAnalysisEvent event) {
        Map<String, String> projectConfig = this.projectConfigProvider.provide(event.getProjectId());
        this.uniqueErrorAnalysisStarter.start(ClusterEntityContext.of((Long)event.getSource(), event.getProjectId()), projectConfig);
    }
}

