/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.listener;

import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.subscriber.EventSubscriber;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import java.util.List;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.event.TransactionalEventListener;

public class LaunchFinishedEventListener {
    private final List<EventSubscriber<LaunchFinishedEvent>> subscribers;

    public LaunchFinishedEventListener(List<EventSubscriber<LaunchFinishedEvent>> subscribers) {
        this.subscribers = subscribers;
    }

    @Async(value="eventListenerExecutor")
    @TransactionalEventListener
    public void onApplicationEvent(LaunchFinishedEvent event) {
        if (LaunchModeEnum.DEBUG == event.getMode()) {
            return;
        }
        this.subscribers.forEach(s -> s.handleEvent(event));
    }
}

