/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.launch;

import com.epam.reportportal.extension.event.LaunchFinishedPluginEvent;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.enums.LogicalOperator;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.project.email.LaunchAttributeRule;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LaunchNotificationRunner
implements ConfigurableEventHandler<LaunchFinishedEvent, Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchNotificationRunner.class);
    private static final String EMAIL_INTEGRATION_NAME = "Email Server";
    private static final String NOTIFICATION_TYPE = "email";
    private final GetProjectHandler getProjectHandler;
    private final GetLaunchHandler getLaunchHandler;
    private final GetIntegrationHandler getIntegrationHandler;
    private final MailServiceFactory mailServiceFactory;
    private final UserRepository userRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public LaunchNotificationRunner(GetProjectHandler getProjectHandler, GetLaunchHandler getLaunchHandler, GetIntegrationHandler getIntegrationHandler, MailServiceFactory mailServiceFactory, UserRepository userRepository, ApplicationEventPublisher eventPublisher) {
        this.getProjectHandler = getProjectHandler;
        this.getLaunchHandler = getLaunchHandler;
        this.getIntegrationHandler = getIntegrationHandler;
        this.mailServiceFactory = mailServiceFactory;
        this.userRepository = userRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Transactional(readOnly=true)
    public void handle(LaunchFinishedEvent launchFinishedEvent, Map<String, String> projectConfig) {
        boolean isNotificationsEnabled;
        boolean bl = isNotificationsEnabled = BooleanUtils.toBoolean((String)projectConfig.get(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute())) && BooleanUtils.toBoolean((String)projectConfig.get(ProjectAttributeEnum.NOTIFICATIONS_EMAIL_ENABLED.getAttribute()));
        if (isNotificationsEnabled) {
            this.getIntegrationHandler.getEnabledByProjectIdOrGlobalAndIntegrationGroup(launchFinishedEvent.getProjectId(), IntegrationGroupEnum.NOTIFICATION).filter(integration -> EMAIL_INTEGRATION_NAME.equalsIgnoreCase(integration.getName())).flatMap(this.mailServiceFactory::getDefaultEmailService).ifPresentOrElse(emailService -> this.sendEmail(launchFinishedEvent, (EmailService)((Object)emailService)), () -> LOGGER.warn("Unable to find {} integration for project {}", (Object)IntegrationGroupEnum.NOTIFICATION, (Object)launchFinishedEvent.getProjectId()));
        }
        if (BooleanUtils.toBoolean((String)projectConfig.get(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute()))) {
            this.sendNotificationEvent(launchFinishedEvent);
        }
    }

    private void sendEmail(LaunchFinishedEvent launchFinishedEvent, EmailService emailService) {
        Launch launch = this.getLaunchHandler.get(launchFinishedEvent.getId());
        Project project = this.getProjectHandler.get(launch.getProjectId());
        project.getSenderCases().stream().filter(SenderCase::isEnabled).filter(senderCase -> senderCase.getType().equals(NOTIFICATION_TYPE)).forEach(ec -> {
            SendCase sendCase = ec.getSendCase();
            boolean successRate = this.isSuccessRateEnough(launch, sendCase);
            boolean matchedNames = LaunchNotificationRunner.isLaunchNameMatched(launch, ec);
            boolean matchedTags = LaunchNotificationRunner.isAttributesMatched(launch, ec.getLaunchAttributeRules(), ec.getAttributesOperator());
            Set recipients = ec.getRecipients();
            if (successRate && matchedNames && matchedTags) {
                String[] recipientsArray = this.findRecipients((String)this.userRepository.findLoginById(launch.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{launch.getUserId()})), recipients);
                try {
                    if (launchFinishedEvent.getBaseUrl() != null) {
                        emailService.sendLaunchFinishNotification(recipientsArray, String.format("%s/ui/#%s", launchFinishedEvent.getBaseUrl(), project.getName()), project, launch);
                    } else {
                        emailService.sendLaunchFinishNotification(recipientsArray, String.format("/ui/#%s", project.getName()), project, launch);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to send email.", (Throwable)e);
                }
            }
        });
    }

    private String[] findRecipients(String owner, Set<String> recipients) {
        return (String[])recipients.stream().map(recipient -> {
            if (recipient.contains("@")) {
                return recipient;
            }
            String toFind = recipient.equals(ProjectUtils.getOwner()) ? owner : recipient;
            Optional user = this.userRepository.findByLogin(toFind);
            return user.map(User::getEmail).orElse(null);
        }).filter(Objects::nonNull).distinct().toArray(String[]::new);
    }

    private static double getSuccessRate(Launch launch) {
        double ti = StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", launch.getStatistics()).doubleValue();
        double pb = StatisticsHelper.extractStatisticsCount("statistics$defects$product_bug$total", launch.getStatistics()).doubleValue();
        double si = StatisticsHelper.extractStatisticsCount("statistics$defects$system_issue$total", launch.getStatistics()).doubleValue();
        double ab = StatisticsHelper.extractStatisticsCount("statistics$defects$automation_bug$total", launch.getStatistics()).doubleValue();
        double total = StatisticsHelper.extractStatisticsCount("statistics$executions$total", launch.getStatistics()).doubleValue();
        return total == 0.0 ? total : (ti + pb + si + ab) / total;
    }

    private boolean isSuccessRateEnough(Launch launch, SendCase option) {
        switch (option) {
            case ALWAYS: {
                return true;
            }
            case FAILED: {
                return this.getLaunchHandler.hasItemsWithIssues(launch);
            }
            case TO_INVESTIGATE: {
                return StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", launch.getStatistics()) > 0;
            }
            case MORE_10: {
                return LaunchNotificationRunner.getSuccessRate(launch) > 0.1;
            }
            case MORE_20: {
                return LaunchNotificationRunner.getSuccessRate(launch) > 0.2;
            }
            case MORE_50: {
                return LaunchNotificationRunner.getSuccessRate(launch) > 0.5;
            }
        }
        return false;
    }

    private static boolean isLaunchNameMatched(Launch launch, SenderCase oneCase) {
        Set configuredNames = oneCase.getLaunchNames();
        return null == configuredNames || configuredNames.isEmpty() || configuredNames.contains(launch.getName());
    }

    @VisibleForTesting
    private static boolean isAttributesMatched(Launch launch, Set<LaunchAttributeRule> launchAttributeRules, LogicalOperator logicalOperator) {
        if (CollectionUtils.isEmpty(launchAttributeRules)) {
            return true;
        }
        Set itemAttributesResource = launchAttributeRules.stream().map(NotificationConfigConverter.TO_ATTRIBUTE_RULE_RESOURCE).collect(Collectors.toSet());
        Set itemAttributes = launch.getAttributes().stream().filter(attribute -> attribute.isSystem() == false).map(attribute -> {
            ItemAttributeResource attributeResource = new ItemAttributeResource();
            attributeResource.setKey(attribute.getKey());
            attributeResource.setValue(attribute.getValue());
            return attributeResource;
        }).collect(Collectors.toSet());
        if (LogicalOperator.AND.equals((Object)logicalOperator)) {
            return itemAttributesResource.stream().allMatch(resourceAttr -> itemAttributes.stream().anyMatch(attr -> LaunchNotificationRunner.areAttributesMatched(attr, resourceAttr)));
        }
        return itemAttributes.stream().anyMatch(attr -> itemAttributesResource.stream().anyMatch(resourceAttr -> LaunchNotificationRunner.areAttributesMatched(attr, resourceAttr)));
    }

    private static boolean areAttributesMatched(ItemAttributeResource itemAttribute, ItemAttributeResource itemAttributeResource) {
        boolean isEqual = Objects.equals(itemAttribute.getKey(), itemAttributeResource.getKey()) && Objects.equals(itemAttribute.getValue(), itemAttributeResource.getValue());
        boolean isValueEqualWithKeyNull = itemAttributeResource.getKey() == null && Objects.equals(itemAttribute.getValue(), itemAttributeResource.getValue());
        return isEqual || isValueEqualWithKeyNull;
    }

    private void sendNotificationEvent(LaunchFinishedEvent launchFinishedEvent) {
        Project project = this.getProjectHandler.get(launchFinishedEvent.getProjectId());
        String launchLink = LinkGenerator.generateLaunchLink(launchFinishedEvent.getBaseUrl(), project.getName(), String.valueOf(launchFinishedEvent.getId()));
        this.eventPublisher.publishEvent((ApplicationEvent)new LaunchFinishedPluginEvent(launchFinishedEvent.getId(), launchFinishedEvent.getProjectId(), launchLink));
    }
}

