/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.item;

import com.epam.ta.reportportal.core.analyzer.pattern.handler.ItemsPatternsAnalyzer;
import com.epam.ta.reportportal.core.events.activity.item.TestItemFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.entity.ItemAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TestItemPatternAnalysisRunner
implements ConfigurableEventHandler<TestItemFinishedEvent, Map<String, String>> {
    protected static final String IMMEDIATE_PATTERN_ANALYSIS = "immediatePatternAnalysis";
    private final ItemsPatternsAnalyzer patternsAnalyzer;

    public TestItemPatternAnalysisRunner(ItemsPatternsAnalyzer patternsAnalyzer) {
        this.patternsAnalyzer = patternsAnalyzer;
    }

    @Override
    public void handle(TestItemFinishedEvent event, Map<String, String> config) {
        if (TestItemPatternAnalysisRunner.isImmediatePaProvided(event)) {
            this.patternsAnalyzer.analyze(event.getProjectId(), event.getTestItem().getLaunchId(), Collections.singletonList(event.getTestItem().getItemId()));
        }
    }

    private static boolean isImmediatePaProvided(TestItemFinishedEvent event) {
        Optional<ItemAttribute> immediatePa = event.getTestItem().getAttributes().stream().filter(it -> IMMEDIATE_PATTERN_ANALYSIS.equals(it.getKey())).findAny();
        return immediatePa.isPresent() && Boolean.parseBoolean(immediatePa.get().getValue());
    }
}

