/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.item;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.activity.item.IssueResolvedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.google.common.collect.Lists;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestItemIndexRunner
implements ConfigurableEventHandler<IssueResolvedEvent, Map<String, String>> {
    private final LogIndexer logIndexer;

    @Autowired
    public TestItemIndexRunner(LogIndexer logIndexer) {
        this.logIndexer = logIndexer;
    }

    @Override
    @Transactional(readOnly=true)
    public void handle(IssueResolvedEvent event, Map<String, String> projectConfig) {
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(projectConfig);
        this.logIndexer.indexItemsLogs(event.getProjectId(), event.getLaunchId(), Lists.newArrayList((Object[])new Long[]{event.getItemId()}), analyzerConfig);
    }
}

