/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerServiceAsync;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.AnalysisEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class StartAnalysisEventHandler {
    private final AnalyzerServiceAsync analyzerServiceAsync;
    private final LogIndexer logIndexer;

    @Autowired
    public StartAnalysisEventHandler(AnalyzerServiceAsync analyzerServiceAsync, LogIndexer logIndexer) {
        this.analyzerServiceAsync = analyzerServiceAsync;
        this.logIndexer = logIndexer;
    }

    @TransactionalEventListener
    public void handleEvent(AnalysisEvent event) {
        this.analyzerServiceAsync.analyze(event.getLaunch(), event.getItemIds(), event.getAnalyzerConfig()).thenApply(it -> this.logIndexer.indexItemsLogs(event.getLaunch().getProjectId(), event.getLaunch().getId(), event.getItemIds(), event.getAnalyzerConfig()));
    }
}

