/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.annotations;

import com.epam.ta.reportportal.core.events.annotations.WidgetLimitRange;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.model.BaseEntityRQ;
import com.epam.ta.reportportal.model.widget.MaterializedWidgetType;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;

public class WidgetLimitRangeValidator
implements ConstraintValidator<WidgetLimitRange, BaseEntityRQ> {
    public boolean isValid(BaseEntityRQ value, ConstraintValidatorContext context) {
        if (value instanceof WidgetRQ) {
            WidgetRQ widgetRQ = (WidgetRQ)value;
            if (WidgetType.TEST_CASE_SEARCH.getType().equalsIgnoreCase(widgetRQ.getWidgetType())) {
                return true;
            }
            int limit = widgetRQ.getContentParameters().getItemsCount();
            if (Arrays.stream(MaterializedWidgetType.values()).anyMatch(it -> it.getType().equalsIgnoreCase(widgetRQ.getWidgetType()))) {
                return limit >= 1;
            }
            this.updateValidationMessage("Widget item limit size must be between 1 and 600", context);
            return limit >= 1 && limit <= 600;
        }
        return false;
    }

    public void updateValidationMessage(String message, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

