/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.model.activity.UserActivityResource;

public class UserCreatedEvent
extends AbstractEvent
implements ActivityEvent {
    private UserActivityResource userActivityResource;
    private final boolean isSystemEvent;

    public UserCreatedEvent(UserActivityResource userActivityResource, Long userId, String userLogin, boolean isSystemEvent) {
        super(userId, userLogin);
        this.userActivityResource = userActivityResource;
        this.isSystemEvent = isSystemEvent;
    }

    public UserActivityResource getUserActivityResource() {
        return this.userActivityResource;
    }

    public void setUserActivityResource(UserActivityResource userActivityResource) {
        this.userActivityResource = userActivityResource;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.CREATE).addEventName(ActivityAction.CREATE_USER.getValue()).addPriority(EventPriority.HIGH).addObjectId(this.userActivityResource.getId()).addObjectName(this.userActivityResource.getFullName()).addObjectType(EventObject.USER).addSubjectId(this.isSystemEvent ? null : this.getUserId()).addSubjectName(this.isSystemEvent ? "ReportPortal" : this.getUserLogin()).addSubjectType(this.isSystemEvent ? EventSubject.APPLICATION : EventSubject.USER).get();
    }
}

