/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.core.events.activity.util.ActivityDetailsUtil;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.model.activity.ProjectAttributesActivityResource;
import java.util.Map;

public class ProjectPatternAnalyzerUpdateEvent
extends AroundEvent<ProjectAttributesActivityResource>
implements ActivityEvent {
    public ProjectPatternAnalyzerUpdateEvent() {
    }

    public ProjectPatternAnalyzerUpdateEvent(ProjectAttributesActivityResource before, ProjectAttributesActivityResource after, Long userId, String userLogin) {
        super(userId, userLogin, before, after);
    }

    @Override
    public Activity toActivity() {
        ProjectAttributesActivityResource before = (ProjectAttributesActivityResource)this.getBefore();
        ProjectAttributesActivityResource after = (ProjectAttributesActivityResource)this.getAfter();
        Map<String, String> oldConfig = before.getConfig();
        Map<String, String> newConfig = after.getConfig();
        ActivityBuilder activityBuilder = new ActivityBuilder().addCreatedNow().addAction(EventAction.UPDATE).addEventName(ActivityAction.UPDATE_PATTERN_ANALYZER.getValue()).addPriority(EventPriority.LOW).addObjectId(before.getProjectId()).addObjectName("pattern").addObjectType(EventObject.PROJECT).addProjectId(before.getProjectId()).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).addHistoryField(ActivityDetailsUtil.processParameter(oldConfig, newConfig, ProjectAttributeEnum.AUTO_PATTERN_ANALYZER_ENABLED.getAttribute()));
        return activityBuilder.get();
    }
}

