/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import java.util.Objects;

public class ProjectDeletedEvent
extends AbstractEvent
implements ActivityEvent {
    private final Long projectId;
    private final String projectName;

    public ProjectDeletedEvent(Long userId, String userLogin, Long projectId, String projectName) {
        super(userId, userLogin);
        this.projectId = projectId;
        this.projectName = projectName;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.DELETE).addEventName(ActivityAction.DELETE_PROJECT.getValue()).addPriority(EventPriority.CRITICAL).addObjectId(this.projectId).addObjectName(this.projectName).addObjectType(EventObject.PROJECT).addSubjectId(this.getUserId()).addSubjectType(Objects.isNull(this.getUserId()) ? EventSubject.APPLICATION : EventSubject.USER).addSubjectName(this.getUserLogin()).get();
    }
}

