/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.activity.HistoryField;
import com.epam.ta.reportportal.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.model.analyzer.RelevantItemInfo;
import java.util.Optional;

public class ItemIssueTypeDefinedEvent
extends AroundEvent<TestItemActivityResource>
implements ActivityEvent {
    private RelevantItemInfo relevantItemInfo;

    public ItemIssueTypeDefinedEvent() {
    }

    public ItemIssueTypeDefinedEvent(TestItemActivityResource before, TestItemActivityResource after, Long userId, String userLogin) {
        super(userId, userLogin, before, after);
    }

    public ItemIssueTypeDefinedEvent(TestItemActivityResource before, TestItemActivityResource after, String userLogin) {
        super(null, userLogin, before, after);
    }

    public ItemIssueTypeDefinedEvent(TestItemActivityResource before, TestItemActivityResource after, String userLogin, RelevantItemInfo relevantItemInfo) {
        super(null, userLogin, before, after);
        this.relevantItemInfo = relevantItemInfo;
    }

    public RelevantItemInfo getRelevantItemInfo() {
        return this.relevantItemInfo;
    }

    public void setRelevantItemInfo(RelevantItemInfo relevantItemInfo) {
        this.relevantItemInfo = relevantItemInfo;
    }

    public boolean isAutoAnalyzed() {
        return ((TestItemActivityResource)this.getAfter()).isAutoAnalyzed();
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.ANALYZE).addEventName(((TestItemActivityResource)this.getAfter()).isAutoAnalyzed() ? ActivityAction.ANALYZE_ITEM.getValue() : ActivityAction.UPDATE_ITEM.getValue()).addPriority(EventPriority.LOW).addObjectId(((TestItemActivityResource)this.getAfter()).getId()).addObjectName(((TestItemActivityResource)this.getAfter()).getName()).addObjectType(EventObject.ITEM_ISSUE).addProjectId(((TestItemActivityResource)this.getAfter()).getProjectId()).addSubjectId(this.isAutoAnalyzed() ? null : this.getUserId()).addSubjectName(this.isAutoAnalyzed() ? "analyzer" : this.getUserLogin()).addSubjectType(this.isAutoAnalyzed() ? EventSubject.APPLICATION : EventSubject.USER).addHistoryField(this.processIssueDescription(((TestItemActivityResource)this.getBefore()).getIssueDescription(), ((TestItemActivityResource)this.getAfter()).getIssueDescription())).addHistoryField(this.processIssueTypes(((TestItemActivityResource)this.getBefore()).getIssueTypeLongName(), ((TestItemActivityResource)this.getAfter()).getIssueTypeLongName())).addHistoryField(this.processIgnoredAnalyzer(((TestItemActivityResource)this.getBefore()).isIgnoreAnalyzer(), ((TestItemActivityResource)this.getAfter()).isIgnoreAnalyzer())).addHistoryField(this.processRelevantItem(this.relevantItemInfo)).get();
    }

    private Optional<HistoryField> processIssueDescription(String before, String after) {
        HistoryField historyField = null;
        after = null != after ? after.trim() : "";
        String string = before = null != before ? before : "";
        if (!before.equals(after)) {
            historyField = HistoryField.of((String)"comment", (String)before, (String)after);
        }
        return Optional.ofNullable(historyField);
    }

    private Optional<HistoryField> processIssueTypes(String before, String after) {
        return before.equalsIgnoreCase(after) ? Optional.empty() : Optional.of(HistoryField.of((String)"issueType", (String)before, (String)after));
    }

    private Optional<HistoryField> processIgnoredAnalyzer(Boolean before, Boolean after) {
        if (!before.equals(after)) {
            return Optional.of(HistoryField.of((String)"ignoreAnalyzer", (String)String.valueOf(before), (String)String.valueOf(after)));
        }
        return Optional.empty();
    }

    private Optional<HistoryField> processRelevantItem(RelevantItemInfo relevantItemInfo) {
        if (null == relevantItemInfo) {
            return Optional.empty();
        }
        return Optional.of(HistoryField.of((String)"relevantItem", null, (String)relevantItemInfo.toString()));
    }
}

