/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.model.activity.UserActivityResource;

public class ChangeRoleEvent
extends AbstractEvent
implements ActivityEvent {
    private UserActivityResource userActivityResource;
    private String oldRole;
    private String newRole;

    public ChangeRoleEvent() {
    }

    public ChangeRoleEvent(UserActivityResource userActivityResource, String oldRole, String newRole, Long userId, String userLogin) {
        super(userId, userLogin);
        this.userActivityResource = userActivityResource;
        this.oldRole = oldRole;
        this.newRole = newRole;
    }

    public UserActivityResource getUserActivityResource() {
        return this.userActivityResource;
    }

    public void setUserActivityResource(UserActivityResource userActivityResource) {
        this.userActivityResource = userActivityResource;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.CHANGE_ROLE).addEventName(ActivityAction.CHANGE_ROLE.getValue()).addPriority(EventPriority.HIGH).addObjectId(this.userActivityResource.getId()).addObjectName(this.userActivityResource.getFullName()).addObjectType(EventObject.USER).addProjectId(this.userActivityResource.getDefaultProjectId()).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).addHistoryField("projectRole", this.oldRole, this.newRole).get();
    }
}

