/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.dashboard.CreateDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.UpdateDashboardHandler;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.widget.CreateWidgetHandler;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.dashboard.AddWidgetRq;
import com.epam.ta.reportportal.model.dashboard.DashboardPreconfiguredRq;
import com.epam.ta.reportportal.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.model.filter.UserFilterResource;
import com.epam.ta.reportportal.model.widget.WidgetConfigResource;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DashboardPreconfiguredService {
    private final CreateDashboardHandler createDashboardHandler;
    private final UpdateDashboardHandler updateDashboardHandler;
    private final CreateWidgetHandler createWidgetHandler;
    private final UpdateUserFilterHandler userFilterHandler;

    public EntryCreatedRS createDashboard(ReportPortalUser.ProjectDetails projectDetails, DashboardPreconfiguredRq rq, ReportPortalUser user) {
        EntryCreatedRS dashboard = this.createDashboardHandler.createDashboard(projectDetails, rq, user);
        this.createAndAddWidgets(dashboard.getId(), rq.getDashboardConfig().getWidgetsConfig(), projectDetails, user);
        return dashboard;
    }

    private void createAndAddWidgets(Long dashboardId, List<WidgetConfigResource> widgetsConfigs, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        HashMap<Long, Long> filterIdMapping = this.createUniqueFilters(widgetsConfigs, projectDetails, user);
        widgetsConfigs.forEach(widgetConfig -> {
            EntryCreatedRS widget = this.createWidgetByConfig(projectDetails, user, this.getNewFilterIds(filterIdMapping, (WidgetConfigResource)widgetConfig), (WidgetConfigResource)widgetConfig);
            widgetConfig.getWidgetObject().setWidgetId(widget.getId());
            this.updateDashboardHandler.addWidget(dashboardId, projectDetails, new AddWidgetRq(widgetConfig.getWidgetObject()), user);
        });
    }

    private EntryCreatedRS createWidgetByConfig(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, List<Long> filterIds, WidgetConfigResource config) {
        WidgetRQ widgetRQ = new WidgetRQ();
        widgetRQ.setName(config.getWidgetResource().getName());
        widgetRQ.setDescription(config.getWidgetResource().getDescription());
        widgetRQ.setWidgetType(config.getWidgetResource().getWidgetType());
        widgetRQ.setContentParameters(config.getWidgetResource().getContentParameters());
        widgetRQ.setFilterIds(filterIds);
        return this.createWidgetHandler.createWidget(widgetRQ, projectDetails, user);
    }

    private List<Long> getNewFilterIds(HashMap<Long, Long> filterIdMapping, WidgetConfigResource config) {
        return config.getWidgetResource().getAppliedFilters().stream().map(it -> (Long)filterIdMapping.get(it.getFilterId())).collect(Collectors.toList());
    }

    private HashMap<Long, Long> createUniqueFilters(List<WidgetConfigResource> widgetsConfigs, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        HashMap<Long, Long> filtersMapping = new HashMap<Long, Long>();
        Map<Long, UserFilterResource> uniqueFilters = widgetsConfigs.stream().flatMap(it -> it.getWidgetResource().getAppliedFilters().stream()).collect(Collectors.toMap(UserFilterResource::getFilterId, f -> f, (existing, current) -> existing));
        uniqueFilters.forEach((id, filter) -> {
            UpdateUserFilterRQ updateUserFilterRQ = new UpdateUserFilterRQ();
            updateUserFilterRQ.setName(filter.getName());
            updateUserFilterRQ.setConditions(filter.getConditions());
            updateUserFilterRQ.setOrders(filter.getOrders());
            updateUserFilterRQ.setObjectType(filter.getObjectType());
            updateUserFilterRQ.setDescription(filter.getDescription());
            EntryCreatedRS createdFilter = this.userFilterHandler.createFilterCopyOnDuplicate(updateUserFilterRQ, projectDetails.getProjectName(), user);
            filtersMapping.put((Long)id, createdFilter.getId());
        });
        return filtersMapping;
    }

    @Generated
    public DashboardPreconfiguredService(CreateDashboardHandler createDashboardHandler, UpdateDashboardHandler updateDashboardHandler, CreateWidgetHandler createWidgetHandler, UpdateUserFilterHandler userFilterHandler) {
        this.createDashboardHandler = createDashboardHandler;
        this.updateDashboardHandler = updateDashboardHandler;
        this.createWidgetHandler = createWidgetHandler;
        this.userFilterHandler = userFilterHandler;
    }
}

