/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.security;

import com.epam.ta.reportportal.auth.CustomAuthenticationEntryPoint;
import com.epam.ta.reportportal.auth.UserRoleHierarchy;
import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.auth.permissions.PermissionEvaluatorFactoryBean;
import com.epam.ta.reportportal.core.configs.security.ApiKeyAuthenticationProvider;
import com.epam.ta.reportportal.core.configs.security.JwtCustomAuthenticationProvider;
import com.epam.ta.reportportal.core.configs.security.JwtReportPortalUserConverter;
import com.epam.ta.reportportal.core.configs.utils.CustomAuthenticationManagerResolver;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(proxyTargetClass=true)
class SecurityConfiguration {
    @Value(value="${rp.jwt.signing-key}")
    private String signingKey;
    @Autowired
    private PermissionEvaluator permissionEvaluator;
    @Autowired
    private DatabaseUserDetailsService userDetailsService;
    @Autowired
    private ServerSettingsRepository serverSettingsRepository;
    @Autowired
    private RoleHierarchy roleHierarchy;
    @Autowired
    private ApiKeyAuthenticationProvider apiKeyAuthenticationProvider;
    @Autowired
    private JwtCustomAuthenticationProvider jwtCustomAuthenticationProvider;
    private static final String SECRET_KEY = "secret.key";

    SecurityConfiguration() {
    }

    @Bean
    @Profile(value={"!unittest"})
    public JwtReportPortalUserConverter accessTokenConverter() {
        JwtReportPortalUserConverter jwtConverter = new JwtReportPortalUserConverter(this.userDetailsService);
        JwtGrantedAuthoritiesConverter jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
        jwtGrantedAuthoritiesConverter.setAuthoritiesClaimName("authorities");
        jwtGrantedAuthoritiesConverter.setAuthorityPrefix("");
        jwtConverter.setJwtGrantedAuthoritiesConverter((Converter<Jwt, Collection<GrantedAuthority>>)jwtGrantedAuthoritiesConverter);
        return jwtConverter;
    }

    @Bean
    public SecurityFilterChain web(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/**/user**/registration/info*", "/**/user**/registration**", "/**/user**/password/reset/*", "/**/user**/password/reset**", "/**/user**/password/restore**", "/**/plugin/public/**", "/documentation.html", "/health", "/info"})).permitAll().requestMatchers(new String[]{"/api-internal/**"})).hasRole("COMPONENT").requestMatchers(new String[]{"/v2/**", "/swagger-resources", "/certificate/**", "/api/**", "/**"})).hasRole("USER").anyRequest()).authenticated()).oauth2ResourceServer(resourceServer -> resourceServer.authenticationManagerResolver((AuthenticationManagerResolver)this.customAuthenticationManagerResolver()).authenticationEntryPoint(this.authenticationEntryPoint())).userDetailsService((UserDetailsService)this.userDetailsService).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new CustomAuthenticationEntryPoint();
    }

    @Bean
    public static PermissionEvaluatorFactoryBean permissionEvaluatorFactoryBean() {
        return new PermissionEvaluatorFactoryBean();
    }

    @Bean
    public static RoleHierarchy userRoleHierarchy() {
        return new UserRoleHierarchy();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @Profile(value={"!unittest"})
    JwtDecoder jwtDecoder() {
        return NimbusJwtDecoder.withSecretKey((SecretKey)this.getSecret()).build();
    }

    @Bean
    public MethodSecurityExpressionHandler createExpressionHandler() {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        handler.setRoleHierarchy(this.roleHierarchy);
        handler.setPermissionEvaluator(this.permissionEvaluator);
        return handler;
    }

    private SecretKey getSecret() {
        String secret = Optional.ofNullable(this.signingKey).filter(StringUtils::isNotEmpty).orElseGet(() -> this.serverSettingsRepository.findByKey(SECRET_KEY).map(ServerSettings::getValue).orElseGet(() -> this.serverSettingsRepository.generateSecret()));
        return new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), 0, secret.length(), "HmacSha256");
    }

    @Bean
    public CustomAuthenticationManagerResolver customAuthenticationManagerResolver() {
        return new CustomAuthenticationManagerResolver(this.apiKeyAuthenticationProvider, this.jwtCustomAuthenticationProvider, this.jwtDecoder());
    }

    @Bean
    public JwtCustomAuthenticationProvider jwtCustomAuthenticationProvider() {
        return new JwtCustomAuthenticationProvider(this.jwtDecoder(), this.userDetailsService);
    }
}

