/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.bts.handler.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.bts.handler.GetBugTrackingSystemHandler;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetBugTrackingSystemHandlerImpl
implements GetBugTrackingSystemHandler {
    private final IntegrationRepository integrationRepository;

    @Autowired
    public GetBugTrackingSystemHandlerImpl(IntegrationRepository integrationRepository) {
        this.integrationRepository = integrationRepository;
    }

    @Override
    public Optional<Integration> getEnabledProjectIntegration(ReportPortalUser.ProjectDetails projectDetails, String url, String btsProject) {
        Optional integration = this.integrationRepository.findProjectBtsByUrlAndLinkedProject(url, btsProject, projectDetails.getProjectId());
        integration.ifPresent(this::validateBtsIntegration);
        return integration;
    }

    @Override
    public Optional<Integration> getEnabledProjectIntegration(ReportPortalUser.ProjectDetails projectDetails, Long integrationId) {
        Optional integration = this.integrationRepository.findByIdAndProjectId(integrationId, projectDetails.getProjectId());
        integration.ifPresent(this::validateBtsIntegration);
        return integration;
    }

    @Override
    public Optional<Integration> getEnabledGlobalIntegration(String url, String btsProject) {
        Optional integration = this.integrationRepository.findGlobalBtsByUrlAndLinkedProject(url, btsProject);
        integration.ifPresent(this::validateBtsIntegration);
        return integration;
    }

    @Override
    public Optional<Integration> getEnabledGlobalIntegration(Long integrationId) {
        Optional integration = this.integrationRepository.findGlobalById(integrationId);
        integration.ifPresent(this::validateBtsIntegration);
        return integration;
    }

    private void validateBtsIntegration(Integration integration) {
        BusinessRule.expect((Object)integration, it -> IntegrationGroupEnum.BTS == it.getType().getIntegrationGroup()).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Unable to test connection to the integration with type - '{}', Allowed type(es): '{}'", (Object[])new Object[]{integration.getType().getIntegrationGroup(), IntegrationGroupEnum.BTS})});
    }
}

