/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.handler.proxy;

import com.epam.ta.reportportal.core.analyzer.pattern.handler.ItemsPatternsAnalyzer;
import com.epam.ta.reportportal.core.analyzer.pattern.handler.proxy.ItemsPatternAnalyzeDto;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Primary
@Component
public class ItemsPatternAnalyzeProducer
implements ItemsPatternsAnalyzer {
    private final PatternTemplateRepository patternTemplateRepository;
    private final boolean isSingleItem;
    private final MessageBus messageBus;

    public ItemsPatternAnalyzeProducer(@Value(value="${rp.environment.variable.pattern-analysis.single-item:true}") boolean isSingleItem, MessageBus messageBus, PatternTemplateRepository patternTemplateRepository) {
        this.isSingleItem = isSingleItem;
        this.messageBus = messageBus;
        this.patternTemplateRepository = patternTemplateRepository;
    }

    @Override
    public void analyze(long projectId, long launchId, List<Long> itemIds) {
        List patternTemplates = this.patternTemplateRepository.findAllByProjectIdAndEnabled(Long.valueOf(projectId), true);
        patternTemplates.forEach(pattern -> this.publishMessage((PatternTemplate)pattern, projectId, launchId, itemIds));
        if (CollectionUtils.isEmpty(itemIds)) {
            this.sendFinishedEvent(projectId, launchId);
        }
    }

    private void publishMessage(PatternTemplate pattern, long projectId, long launchId, List<Long> itemIds) {
        if (this.isSingleItem) {
            itemIds.forEach(id -> this.messageBus.publish("pattern.analysis", pattern.getTemplateType().name(), new ItemsPatternAnalyzeDto(projectId, launchId, Collections.singletonList(id), pattern)));
        } else {
            this.messageBus.publish("pattern.analysis", pattern.getTemplateType().name(), new ItemsPatternAnalyzeDto(projectId, launchId, itemIds, pattern));
        }
    }

    public void sendFinishedEvent(long projectId, long launchId) {
        this.messageBus.publish("pattern.analysis", PatternTemplateType.REGEX.name(), new ItemsPatternAnalyzeDto(projectId, launchId, Collections.emptyList(), true));
    }
}

