/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.handler.proxy;

import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.pattern.handler.impl.ItemsPatternAnalyzerImpl;
import com.epam.ta.reportportal.core.analyzer.pattern.handler.proxy.ItemsPatternAnalyzeDto;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class ItemsPatternAnalyzeConsumer {
    private final ItemsPatternAnalyzerImpl itemsPatternsAnalyzer;
    private final AnalyzerStatusCache analyzerStatusCache;

    public ItemsPatternAnalyzeConsumer(ItemsPatternAnalyzerImpl itemsPatternsAnalyzer, AnalyzerStatusCache analyzerStatusCache) {
        this.itemsPatternsAnalyzer = itemsPatternsAnalyzer;
        this.analyzerStatusCache = analyzerStatusCache;
    }

    @RabbitListener(queues={"analysis.pattern.regex", "analysis.pattern.string"}, containerFactory="patternAnalysisContainerFactory")
    public void handleEvent(ItemsPatternAnalyzeDto event) {
        if (event.isLastItem()) {
            this.analyzerStatusCache.analyzeFinished("patternAnalyzer", event.getLaunchId());
        } else {
            this.itemsPatternsAnalyzer.analyzeByPattern(event.getPatternTemplate(), event.getLaunchId(), event.getItemIds());
        }
    }
}

