/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.search;

import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLaunchesCollector;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class LaunchNameCollector
implements SearchLaunchesCollector {
    private final LaunchRepository launchRepository;

    public LaunchNameCollector(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Override
    public List<Long> collect(Long filerId, Launch launch) {
        ProjectFilter filter = ProjectFilter.of((Queryable)Filter.builder().withTarget(Launch.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq("name", launch.getName()).build()).build(), (Long)launch.getProjectId());
        PageRequest pageRequest = PageRequest.of((int)0, (int)10, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"startTime"}));
        return this.launchRepository.findByFilter((Queryable)filter, (Pageable)pageRequest).stream().map(Launch::getId).collect(Collectors.toList());
    }
}

