/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.search;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLaunchesCollector;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class FilterCollector
implements SearchLaunchesCollector {
    private LaunchRepository launchRepository;
    private UserFilterRepository userFilterRepository;

    @Autowired
    public FilterCollector(LaunchRepository launchRepository, UserFilterRepository userFilterRepository) {
        this.launchRepository = launchRepository;
        this.userFilterRepository = userFilterRepository;
    }

    @Override
    public List<Long> collect(Long filerId, Launch launch) {
        UserFilter userFilter = (UserFilter)this.userFilterRepository.findByIdAndProjectId(filerId, launch.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{filerId, launch.getProjectId()}));
        ObjectType targetClass = userFilter.getTargetClass();
        BusinessRule.expect((Object)targetClass, (Predicate)Predicates.equalTo((Object)ObjectType.Launch)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Filter type '{}' is not supported", (Object[])new Object[]{targetClass})});
        ProjectFilter filter = ProjectFilter.of((Queryable)new Filter(targetClass.getClassObject(), (List)Lists.newArrayList((Iterable)userFilter.getFilterCondition())), (Long)launch.getProjectId());
        PageRequest pageable = PageRequest.of((int)0, (int)10, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"startTime"}));
        return this.launchRepository.findByFilter((Queryable)filter, (Pageable)pageable).stream().map(Launch::getId).collect(Collectors.toList());
    }
}

