/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsCollector;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManuallyAnalyzedCollector
implements AnalyzeItemsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeItemsCollector.class);
    private final TestItemRepository testItemRepository;
    private final IssueTypeRepository issueTypeRepository;
    private final LogIndexer logIndexer;
    private final UpdateTestItemHandler updateTestItemHandler;

    @Autowired
    public ManuallyAnalyzedCollector(TestItemRepository testItemRepository, IssueTypeRepository issueTypeRepository, LogIndexer logIndexer, UpdateTestItemHandler updateTestItemHandler) {
        this.testItemRepository = testItemRepository;
        this.issueTypeRepository = issueTypeRepository;
        this.logIndexer = logIndexer;
        this.updateTestItemHandler = updateTestItemHandler;
    }

    @Override
    public List<Long> collectItems(Long projectId, Long launchId, ReportPortalUser user) {
        List excludedTypes = this.issueTypeRepository.findByLocator(TestItemIssueGroup.TO_INVESTIGATE.getLocator()).map(List::of).orElseGet(Collections::emptyList);
        List itemIds = this.testItemRepository.selectIdsByAnalyzedWithLevelGteExcludingIssueTypes(false, false, launchId, LogLevel.ERROR.toInt(), (Collection)excludedTypes);
        int deletedLogsCount = this.logIndexer.indexItemsRemove(projectId, itemIds);
        LOGGER.debug("{} logs deleted from analyzer", (Object)deletedLogsCount);
        this.updateTestItemHandler.resetItemsIssue(itemIds, projectId, user);
        return itemIds;
    }
}

