/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.SuggestInfo;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.SuggestRq;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.ClusterData;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.GenerateClustersRq;
import com.epam.ta.reportportal.model.analyzer.AnalyzedItemRs;
import com.epam.ta.reportportal.model.analyzer.SearchRq;
import com.epam.ta.reportportal.model.analyzer.SearchRs;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AnalyzerServiceClientImpl
implements AnalyzerServiceClient {
    private static final String ANALYZE_ROUTE = "analyze";
    private static final String SEARCH_ROUTE = "search";
    private static final String SUGGEST_ROUTE = "suggest";
    private static final String SUGGEST_INFO_ROUTE = "index_suggest_info";
    private static final String REMOVE_SUGGEST_ROUTE = "remove_suggest_info";
    private static final String CLUSTER_ROUTE = "cluster";
    private final RabbitMqManagementClient rabbitMqManagementClient;
    private final RabbitTemplate rabbitTemplate;
    private String virtualHost;

    @Autowired
    public AnalyzerServiceClientImpl(RabbitMqManagementClient rabbitMqManagementClient, @Qualifier(value="analyzerRabbitTemplate") RabbitTemplate rabbitTemplate, @Value(value="${rp.amqp.analyzer-vhost}") String virtualHost) {
        this.rabbitMqManagementClient = rabbitMqManagementClient;
        this.rabbitTemplate = rabbitTemplate;
        this.virtualHost = virtualHost;
    }

    @Override
    public boolean hasClients() {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().size() != 0;
    }

    @Override
    public Map<String, List<AnalyzedItemRs>> analyze(IndexLaunch rq) {
        List<ExchangeInfo> analyzerExchanges = this.rabbitMqManagementClient.getAnalyzerExchangesInfo();
        HashMap<String, List<AnalyzedItemRs>> resultMap = new HashMap<String, List<AnalyzedItemRs>>(analyzerExchanges.size());
        analyzerExchanges.forEach(exchange -> this.analyze(rq, (Map<String, List<AnalyzedItemRs>>)resultMap, (ExchangeInfo)exchange));
        return resultMap;
    }

    @Override
    public List<SearchRs> searchLogs(SearchRq rq) {
        String exchangeName = this.resolveExchangeName(AnalyzerUtils.DOES_SUPPORT_SEARCH).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services with search logs support deployed."}));
        return (List)this.rabbitTemplate.convertSendAndReceiveAsType(exchangeName, SEARCH_ROUTE, (Object)rq, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SearchRs>>(this){});
    }

    @Override
    public void removeSuggest(Long projectId) {
        this.resolveExchangeName(AnalyzerUtils.DOES_SUPPORT_SUGGEST).ifPresent(suggestExchange -> this.rabbitTemplate.convertAndSend(suggestExchange, REMOVE_SUGGEST_ROUTE, (Object)projectId));
    }

    @Override
    public List<SuggestInfo> searchSuggests(SuggestRq rq) {
        return (List)this.rabbitTemplate.convertSendAndReceiveAsType(this.getSuggestExchangeName(), SUGGEST_ROUTE, (Object)rq, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SuggestInfo>>(this){});
    }

    @Override
    public void handleSuggestChoice(List<SuggestInfo> suggestInfos) {
        this.rabbitTemplate.convertAndSend(this.getSuggestExchangeName(), SUGGEST_INFO_ROUTE, suggestInfos);
    }

    @Override
    public ClusterData generateClusters(GenerateClustersRq generateClustersRq) {
        String exchangeName = this.resolveExchangeName(AnalyzerUtils.DOES_SUPPORT_CLUSTER).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services with clusters creation support deployed."}));
        return (ClusterData)this.rabbitTemplate.convertSendAndReceiveAsType(exchangeName, CLUSTER_ROUTE, (Object)generateClustersRq, (ParameterizedTypeReference)new ParameterizedTypeReference<ClusterData>(this){});
    }

    private Optional<String> resolveExchangeName(Predicate<ExchangeInfo> supportCondition) {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(supportCondition).min(Comparator.comparingInt(AnalyzerUtils.EXCHANGE_PRIORITY)).map(ExchangeInfo::getName);
    }

    private String getSuggestExchangeName() {
        return this.resolveExchangeName(AnalyzerUtils.DOES_SUPPORT_SUGGEST).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services with suggest items support deployed."}));
    }

    private void analyze(IndexLaunch rq, Map<String, List<AnalyzedItemRs>> resultMap, ExchangeInfo exchangeInfo) {
        List result = (List)this.rabbitTemplate.convertSendAndReceiveAsType(exchangeInfo.getName(), ANALYZE_ROUTE, Collections.singletonList(rq), (ParameterizedTypeReference)new ParameterizedTypeReference<List<AnalyzedItemRs>>(this){});
        if (!CollectionUtils.isEmpty((Collection)result)) {
            resultMap.put(exchangeInfo.getArguments().getOrDefault(this.virtualHost, exchangeInfo.getName()), result);
            this.removeAnalyzedFromRq(rq, result);
        }
    }

    private void removeAnalyzedFromRq(IndexLaunch rq, List<AnalyzedItemRs> analyzed) {
        List analyzedItemIds = analyzed.stream().map(AnalyzedItemRs::getItemId).collect(Collectors.toList());
        rq.getTestItems().removeIf(it -> analyzedItemIds.contains(it.getTestItemId()));
    }
}

