/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analytics;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analytics.AnalyticsObjectType;
import com.epam.ta.reportportal.core.analytics.DefectUpdateStatisticsService;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.dao.AnalyticsDataRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.Metadata;
import com.epam.ta.reportportal.entity.analytics.AnalyticsData;
import com.epam.ta.reportportal.entity.project.Project;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefectUpdateStatisticsServiceImpl
implements DefectUpdateStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefectUpdateStatisticsServiceImpl.class);
    public static final String SERVER_ANALYTICS_ALL = "server.analytics.all";
    private final String buildVersion;
    private final AnalyticsDataRepository analyticsDataRepository;
    private final AnalyzerServiceClient analyzerServicesClient;
    private final ProjectRepository projectRepository;
    private final ServerSettingsRepository serverSettingsRepository;

    @Autowired
    public DefectUpdateStatisticsServiceImpl(@Value(value="${info.build.version:unknown}") String buildVersion, AnalyticsDataRepository analyticsDataRepository, AnalyzerServiceClient analyzerServicesClient, ProjectRepository projectRepository, ServerSettingsRepository serverSettingsRepository) {
        this.buildVersion = buildVersion;
        this.analyzerServicesClient = analyzerServicesClient;
        this.analyticsDataRepository = analyticsDataRepository;
        this.projectRepository = projectRepository;
        this.serverSettingsRepository = serverSettingsRepository;
    }

    @Override
    public void saveAnalyzedDefectStatistics(int amountToAnalyze, int analyzedAmount, int userAnalyzedAmount, int skipped, Long projectId) {
        if (this.isAnalyticsGatheringAllowed()) {
            Map<String, Object> map = this.getMapWithCommonParameters(projectId);
            map.put("sentToAnalyze", amountToAnalyze);
            map.put("analyzed", analyzedAmount);
            map.put("userAnalyzed", userAnalyzedAmount);
            map.put("skipped", skipped);
            AnalyticsData ad = new AnalyticsData();
            ad.setType(AnalyticsObjectType.DEFECT_UPDATE_STATISTICS.name());
            ad.setCreatedAt(Instant.now());
            ad.setMetadata(new Metadata(map));
            this.analyticsDataRepository.save((Object)ad);
        }
    }

    @Override
    public void saveAutoAnalyzedDefectStatistics(int amountToAnalyze, int analyzedAmount, int skipped, Long projectId) {
        this.saveAnalyzedDefectStatistics(amountToAnalyze, analyzedAmount, 0, skipped, projectId);
    }

    @Override
    public void saveUserAnalyzedDefectStatistics(int userAnalyzed, Long projectId) {
        this.saveAnalyzedDefectStatistics(userAnalyzed, 0, userAnalyzed, 0, projectId);
    }

    private boolean isAnalyticsGatheringAllowed() {
        return this.serverSettingsRepository.selectServerSettings().stream().filter(setting -> setting.getKey().equals(SERVER_ANALYTICS_ALL)).findFirst().map(serverSettings -> Boolean.parseBoolean(serverSettings.getValue())).orElse(false);
    }

    private Map<String, Object> getMapWithCommonParameters(Long projectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoAnalysisOn", this.getIsAutoAnalyzerEnabled(projectId));
        try {
            map.put("analyzerEnabled", this.analyzerServicesClient.hasClients());
        }
        catch (ReportPortalException rpe) {
            LOGGER.debug("Analyzer is not enabled", (Throwable)rpe);
        }
        map.put("version", this.buildVersion);
        return map;
    }

    private boolean getIsAutoAnalyzerEnabled(Long projectId) {
        Project project = (Project)this.projectRepository.findById((Object)projectId).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId}));
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        return analyzerConfig.getIsAutoAnalyzerEnabled();
    }
}

