/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.activityevent.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.activityevent.ActivityEventHandler;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.model.ActivityEventResource;
import com.epam.ta.reportportal.model.PagedResponse;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.ActivityEventConverter;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActivityEventHandlerImpl
implements ActivityEventHandler {
    private static final String LENGTH_LESS_THAN_1_SYMBOL_MSG = "Length of the filtering string '{}' is less than 1 symbol";
    private final ActivityRepository activityRepository;

    public ActivityEventHandlerImpl(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @Override
    public PagedResponse<ActivityEventResource> getActivityEventsHistory(Queryable filter, Pageable pageable) {
        Page activityPage = this.activityRepository.findByFilter(filter, pageable);
        return PagedResourcesAssembler.pagedResponseConverter(ActivityEventConverter.TO_RESOURCE).apply((Page<Activity>)activityPage);
    }

    @Override
    public List<String> getSubjectNames(ReportPortalUser.ProjectDetails projectDetails, String value) {
        this.checkBusinessRuleLessThan1Symbol(value);
        return this.activityRepository.findSubjectNameByProjectIdAndSubjectName(projectDetails.getProjectId(), value.toLowerCase());
    }

    private void checkBusinessRuleLessThan1Symbol(String value) {
        BusinessRule.expect((Object)(!value.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)LENGTH_LESS_THAN_1_SYMBOL_MSG, (Object[])new Object[]{value})});
    }
}

