/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.auth.permissions.LookupPermission;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="assignedToProjectPermission")
@LookupPermission(value={"isAssignedToProject"})
class AssignedToProjectPermission
implements Permission {
    private final ProjectExtractor projectExtractor;

    @Autowired
    AssignedToProjectPermission(ProjectExtractor projectExtractor) {
        this.projectExtractor = projectExtractor;
    }

    @Override
    public boolean isAllowed(Authentication authentication, Object targetDomainObject) {
        if (!authentication.isAuthenticated()) {
            return false;
        }
        ReportPortalUser rpUser = (ReportPortalUser)authentication.getPrincipal();
        BusinessRule.expect((Object)rpUser, Objects::nonNull).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        String resolvedProjectName = String.valueOf(targetDomainObject);
        Optional<ReportPortalUser.ProjectDetails> projectDetails = this.projectExtractor.findProjectDetails(rpUser, resolvedProjectName);
        projectDetails.ifPresent(details -> this.fillProjectDetails(rpUser, resolvedProjectName, (ReportPortalUser.ProjectDetails)details));
        return projectDetails.isPresent();
    }

    private void fillProjectDetails(ReportPortalUser rpUser, String resolvedProjectName, ReportPortalUser.ProjectDetails projectDetails) {
        HashMap projectDetailsMapping = Maps.newHashMapWithExpectedSize((int)1);
        projectDetailsMapping.put(resolvedProjectName, projectDetails);
        rpUser.setProjectDetails((Map)projectDetailsMapping);
    }
}

