/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.auth.permissions.LookupPermission;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.user.User;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="allowedToOwnerPermission")
@LookupPermission(value={"allowedToOwner"})
public class AllowedToOwner
implements Permission {
    private final UserRepository userRepository;

    public AllowedToOwner(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public boolean isAllowed(Authentication authentication, Object id) {
        ReportPortalUser rpUser = (ReportPortalUser)authentication.getPrincipal();
        BusinessRule.expect((Object)rpUser, Objects::nonNull).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        Long userIdParameter = Long.parseLong(String.valueOf(id));
        User user = (User)this.userRepository.findById((Object)userIdParameter).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userIdParameter}));
        return rpUser.getUserId().equals(user.getId());
    }
}

