/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import com.epam.ta.reportportal.entity.user.UserRole;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UserRoleHierarchy
implements RoleHierarchy {
    @Generated
    private static final Logger log = LogManager.getLogger(UserRoleHierarchy.class);
    public static final String ROLE_REGISTERED = "ROLE_REGISTERED";
    public static final String ROLE_COMPONENT = "ROLE_COMPONENT";
    private Map<GrantedAuthority, Set<GrantedAuthority>> authoritiesMap = Arrays.stream(UserRole.values()).collect(Collectors.toMap(this::asAuthority, this::findReachableRoles));

    public UserRoleHierarchy() {
        SimpleGrantedAuthority component = new SimpleGrantedAuthority(ROLE_COMPONENT);
        this.authoritiesMap.put((GrantedAuthority)component, (Set<GrantedAuthority>)ImmutableSet.builder().add((Object)component).build());
    }

    public Collection<? extends GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null || authorities.isEmpty()) {
            return AuthorityUtils.NO_AUTHORITIES;
        }
        List reachableRoles = authorities.stream().filter(authority -> this.authoritiesMap.containsKey(authority)).flatMap(authority -> this.authoritiesMap.get(authority).stream()).collect(Collectors.toList());
        log.debug("getReachableGrantedAuthorities() - From the roles {} one can reach {} in zero or more steps.", authorities, reachableRoles);
        return reachableRoles;
    }

    private Set<GrantedAuthority> findReachableRoles(UserRole authority) {
        HashSet<GrantedAuthority> reachableRoles = new HashSet<GrantedAuthority>();
        UserRole[] roles = UserRole.values();
        int startIndex = Arrays.binarySearch(UserRole.values(), authority);
        for (int i = 0; i <= startIndex; ++i) {
            reachableRoles.add(this.asAuthority(roles[i]));
        }
        return reachableRoles;
    }

    private GrantedAuthority asAuthority(UserRole userRole) {
        return new SimpleGrantedAuthority(userRole.getAuthority());
    }
}

