/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.lang.Nullable;

@Schema(name="UpdateGroupRequest", description="Update group request.")
public class UpdateGroupRequest {
    private String name;
    @Nullable
    private String slug;

    public UpdateGroupRequest() {
    }

    public UpdateGroupRequest(String name) {
        this.name = name;
    }

    public UpdateGroupRequest(String name, @Nullable String slug) {
        this.name = name;
        this.slug = slug;
    }

    public UpdateGroupRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$")
    @Size(min=3, max=60)
    @Schema(name="name", description="Display name.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public @NotNull @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$") @Size(min=3, max=60) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateGroupRequest slug(String slug) {
        this.slug = slug;
        return this;
    }

    @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$")
    @Size(min=3, max=60)
    @Schema(name="slug", description="A slug is used to identify a resource. It should be unique and contain only lowercase letters, numbers, and hyphens. It should not start or end with a hyphen.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="slug")
    public @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$") @Size(min=3, max=60) String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateGroupRequest updateGroupRequest = (UpdateGroupRequest)o;
        return Objects.equals(this.name, updateGroupRequest.name) && Objects.equals(this.slug, updateGroupRequest.slug);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.slug);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateGroupRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    slug: ").append(this.toIndentedString(this.slug)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private UpdateGroupRequest instance;

        public Builder() {
            this(new UpdateGroupRequest());
        }

        protected Builder(UpdateGroupRequest instance) {
            this.instance = instance;
        }

        protected Builder copyOf(UpdateGroupRequest value) {
            this.instance.setName(value.name);
            this.instance.setSlug(value.slug);
            return this;
        }

        public Builder name(String name) {
            this.instance.name(name);
            return this;
        }

        public Builder slug(String slug) {
            this.instance.slug(slug);
            return this;
        }

        public UpdateGroupRequest build() {
            try {
                UpdateGroupRequest updateGroupRequest = this.instance;
                return updateGroupRequest;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

