/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

@Schema(name="Offset", description="Offset-based pagination")
public class Offset {
    private Integer offset = 0;
    private Integer limit = 300;
    @Nullable
    private Integer totalCount;
    @Nullable
    private String sort;
    @Nullable
    private Sort.Direction order;

    public Offset() {
    }

    public Offset(Integer offset, Integer limit, @Nullable Integer totalCount, @Nullable String sort, @Nullable Sort.Direction order) {
        this.offset = offset;
        this.limit = limit;
        this.totalCount = totalCount;
        this.sort = sort;
        this.order = order;
    }

    public Offset offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Min(value=0L)
    @Schema(name="offset", description="The offset used for this page of results.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="offset")
    public @Min(value=0L) Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Offset limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Min(value=0L)
    @Schema(name="limit", description="The limit used for this page of results. This will be the same as the limit query parameter unless it exceeded the maximum value allowed for this API endpoint.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="limit")
    public @Min(value=0L) Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Offset totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Min(value=0L)
    @Schema(name="total_count", description="One greater than the offset of the last item in the entire collection. The total number of items in the collection may be less than total_count.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total_count")
    public @Min(value=0L) Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Offset sort(String sort) {
        this.sort = sort;
        return this;
    }

    @Schema(name="sort", description="Field to define the sort field.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sort")
    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public Offset order(Sort.Direction order) {
        this.order = order;
        return this;
    }

    @Valid
    @Schema(name="order", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="order")
    public Sort.Direction getOrder() {
        return this.order;
    }

    public void setOrder(Sort.Direction order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offset offset = (Offset)o;
        return Objects.equals(this.offset, offset.offset) && Objects.equals(this.limit, offset.limit) && Objects.equals(this.totalCount, offset.totalCount) && Objects.equals(this.sort, offset.sort) && Objects.equals(this.order, offset.order);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.limit, this.totalCount, this.sort, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Offset {\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private Offset instance;

        public Builder() {
            this(new Offset());
        }

        protected Builder(Offset instance) {
            this.instance = instance;
        }

        protected Builder copyOf(Offset value) {
            this.instance.setOffset(value.offset);
            this.instance.setLimit(value.limit);
            this.instance.setTotalCount(value.totalCount);
            this.instance.setSort(value.sort);
            this.instance.setOrder(value.order);
            return this;
        }

        public Builder offset(Integer offset) {
            this.instance.offset(offset);
            return this;
        }

        public Builder limit(Integer limit) {
            this.instance.limit(limit);
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.instance.totalCount(totalCount);
            return this;
        }

        public Builder sort(String sort) {
            this.instance.sort(sort);
            return this;
        }

        public Builder order(Sort.Direction order) {
            this.instance.order(order);
            return this;
        }

        public Offset build() {
            try {
                Offset offset = this.instance;
                return offset;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

