/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.AccountType;
import com.epam.reportportal.api.model.InstanceRole;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;

@Schema(name="GroupUserInfo", description="Information about a user as a group member.")
public class GroupUserInfo {
    @Nullable
    private Long id;
    @Nullable
    private UUID uuid;
    @Nullable
    private String email;
    @Nullable
    private String fullName;
    @Nullable
    private String externalId;
    private InstanceRole instanceRole = InstanceRole.USER;
    @Nullable
    private Boolean active;
    private AccountType accountType = AccountType.INTERNAL;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant addedAt;

    public GroupUserInfo() {
    }

    public GroupUserInfo(@Nullable Long id, @Nullable UUID uuid, @Nullable String email, @Nullable String fullName, @Nullable String externalId, InstanceRole instanceRole, @Nullable Boolean active, AccountType accountType, @Nullable Instant addedAt) {
        this.id = id;
        this.uuid = uuid;
        this.email = email;
        this.fullName = fullName;
        this.externalId = externalId;
        this.instanceRole = instanceRole;
        this.active = active;
        this.accountType = accountType;
        this.addedAt = addedAt;
    }

    public GroupUserInfo id(Long id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @Schema(name="id", description="Resource identifier.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public @Min(value=1L) Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GroupUserInfo uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Valid
    @Schema(name="uuid", description="User identifier for external systems.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public GroupUserInfo email(String email) {
        this.email = email;
        return this;
    }

    @Email
    @Schema(name="email", description="User email.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public GroupUserInfo fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$")
    @Size(min=3, max=60)
    @Schema(name="full_name", description="Display name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="full_name")
    public @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$") @Size(min=3, max=60) String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public GroupUserInfo externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(name="external_id", description="External user identifier.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public GroupUserInfo instanceRole(InstanceRole instanceRole) {
        this.instanceRole = instanceRole;
        return this;
    }

    @Valid
    @Schema(name="instance_role", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="instance_role")
    public InstanceRole getInstanceRole() {
        return this.instanceRole;
    }

    public void setInstanceRole(InstanceRole instanceRole) {
        this.instanceRole = instanceRole;
    }

    public GroupUserInfo active(Boolean active) {
        this.active = active;
        return this;
    }

    @Schema(name="active", description="User activity status.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public GroupUserInfo accountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @Valid
    @Schema(name="account_type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="account_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public GroupUserInfo addedAt(Instant addedAt) {
        this.addedAt = addedAt;
        return this;
    }

    @Valid
    @Schema(name="added_at", description="Timestamp of user adding to group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="added_at")
    public Instant getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(Instant addedAt) {
        this.addedAt = addedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUserInfo groupUserInfo = (GroupUserInfo)o;
        return Objects.equals(this.id, groupUserInfo.id) && Objects.equals(this.uuid, groupUserInfo.uuid) && Objects.equals(this.email, groupUserInfo.email) && Objects.equals(this.fullName, groupUserInfo.fullName) && Objects.equals(this.externalId, groupUserInfo.externalId) && Objects.equals((Object)this.instanceRole, (Object)groupUserInfo.instanceRole) && Objects.equals(this.active, groupUserInfo.active) && Objects.equals((Object)this.accountType, (Object)groupUserInfo.accountType) && Objects.equals(this.addedAt, groupUserInfo.addedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.uuid, this.email, this.fullName, this.externalId, this.instanceRole, this.active, this.accountType, this.addedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupUserInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    instanceRole: ").append(this.toIndentedString((Object)this.instanceRole)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    addedAt: ").append(this.toIndentedString(this.addedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private GroupUserInfo instance;

        public Builder() {
            this(new GroupUserInfo());
        }

        protected Builder(GroupUserInfo instance) {
            this.instance = instance;
        }

        protected Builder copyOf(GroupUserInfo value) {
            this.instance.setId(value.id);
            this.instance.setUuid(value.uuid);
            this.instance.setEmail(value.email);
            this.instance.setFullName(value.fullName);
            this.instance.setExternalId(value.externalId);
            this.instance.setInstanceRole(value.instanceRole);
            this.instance.setActive(value.active);
            this.instance.setAccountType(value.accountType);
            this.instance.setAddedAt(value.addedAt);
            return this;
        }

        public Builder id(Long id) {
            this.instance.id(id);
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.instance.uuid(uuid);
            return this;
        }

        public Builder email(String email) {
            this.instance.email(email);
            return this;
        }

        public Builder fullName(String fullName) {
            this.instance.fullName(fullName);
            return this;
        }

        public Builder externalId(String externalId) {
            this.instance.externalId(externalId);
            return this;
        }

        public Builder instanceRole(InstanceRole instanceRole) {
            this.instance.instanceRole(instanceRole);
            return this;
        }

        public Builder active(Boolean active) {
            this.instance.active(active);
            return this;
        }

        public Builder accountType(AccountType accountType) {
            this.instance.accountType(accountType);
            return this;
        }

        public Builder addedAt(Instant addedAt) {
            this.instance.addedAt(addedAt);
            return this;
        }

        public GroupUserInfo build() {
            try {
                GroupUserInfo groupUserInfo = this.instance;
                return groupUserInfo;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

