/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.GroupInfoStats;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;

@Schema(name="GroupInfo", description="Group information.")
public class GroupInfo {
    @Nullable
    private Long id;
    @Nullable
    private UUID uuid;
    @Nullable
    private String name;
    @Nullable
    private String slug;
    @Nullable
    private Long createdBy;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant createdAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant updatedAt;
    @Nullable
    private GroupInfoStats stats;

    public GroupInfo() {
    }

    public GroupInfo(@Nullable Long id, @Nullable UUID uuid, @Nullable String name, @Nullable String slug, @Nullable Long createdBy, @Nullable Instant createdAt, @Nullable Instant updatedAt, @Nullable GroupInfoStats stats) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.slug = slug;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.stats = stats;
    }

    public GroupInfo id(Long id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @Schema(name="id", description="Resource identifier.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public @Min(value=1L) Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GroupInfo uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Valid
    @Schema(name="uuid", description="Global identifier of the group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public GroupInfo name(String name) {
        this.name = name;
        return this;
    }

    @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$")
    @Size(min=3, max=60)
    @Schema(name="name", description="Display name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$") @Size(min=3, max=60) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupInfo slug(String slug) {
        this.slug = slug;
        return this;
    }

    @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$")
    @Size(min=3, max=60)
    @Schema(name="slug", description="A slug is used to identify a resource. It should be unique and contain only lowercase letters, numbers, and hyphens. It should not start or end with a hyphen.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="slug")
    public @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$") @Size(min=3, max=60) String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public GroupInfo createdBy(Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(name="created_by", description="User ID of the user who created the group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="created_by")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public GroupInfo createdAt(Instant createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Valid
    @Schema(name="created_at", description="Timestamp when group was created.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="created_at")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public GroupInfo updatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Valid
    @Schema(name="updated_at", description="Timestamp when group was last updated.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updated_at")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public GroupInfo stats(GroupInfoStats stats) {
        this.stats = stats;
        return this;
    }

    @Valid
    @Schema(name="stats", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="stats")
    public GroupInfoStats getStats() {
        return this.stats;
    }

    public void setStats(GroupInfoStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupInfo groupInfo = (GroupInfo)o;
        return Objects.equals(this.id, groupInfo.id) && Objects.equals(this.uuid, groupInfo.uuid) && Objects.equals(this.name, groupInfo.name) && Objects.equals(this.slug, groupInfo.slug) && Objects.equals(this.createdBy, groupInfo.createdBy) && Objects.equals(this.createdAt, groupInfo.createdAt) && Objects.equals(this.updatedAt, groupInfo.updatedAt) && Objects.equals(this.stats, groupInfo.stats);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uuid, this.name, this.slug, this.createdBy, this.createdAt, this.updatedAt, this.stats);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    slug: ").append(this.toIndentedString(this.slug)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private GroupInfo instance;

        public Builder() {
            this(new GroupInfo());
        }

        protected Builder(GroupInfo instance) {
            this.instance = instance;
        }

        protected Builder copyOf(GroupInfo value) {
            this.instance.setId(value.id);
            this.instance.setUuid(value.uuid);
            this.instance.setName(value.name);
            this.instance.setSlug(value.slug);
            this.instance.setCreatedBy(value.createdBy);
            this.instance.setCreatedAt(value.createdAt);
            this.instance.setUpdatedAt(value.updatedAt);
            this.instance.setStats(value.stats);
            return this;
        }

        public Builder id(Long id) {
            this.instance.id(id);
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.instance.uuid(uuid);
            return this;
        }

        public Builder name(String name) {
            this.instance.name(name);
            return this;
        }

        public Builder slug(String slug) {
            this.instance.slug(slug);
            return this;
        }

        public Builder createdBy(Long createdBy) {
            this.instance.createdBy(createdBy);
            return this;
        }

        public Builder createdAt(Instant createdAt) {
            this.instance.createdAt(createdAt);
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.instance.updatedAt(updatedAt);
            return this;
        }

        public Builder stats(GroupInfoStats stats) {
            this.instance.stats(stats);
            return this;
        }

        public GroupInfo build() {
            try {
                GroupInfo groupInfo = this.instance;
                return groupInfo;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

