/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api;

import com.epam.reportportal.api.model.AddProjectToGroupByIdRequest;
import com.epam.reportportal.api.model.CreateGroupRequest;
import com.epam.reportportal.api.model.GroupInfo;
import com.epam.reportportal.api.model.GroupPage;
import com.epam.reportportal.api.model.GroupProjectInfo;
import com.epam.reportportal.api.model.GroupProjectsPage;
import com.epam.reportportal.api.model.GroupUserInfo;
import com.epam.reportportal.api.model.GroupUsersPage;
import com.epam.reportportal.api.model.Problem;
import com.epam.reportportal.api.model.SuccessfulUpdate;
import com.epam.reportportal.api.model.UpdateGroupRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Groups", description="Group API collection")
public interface GroupsApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="addProjectToGroupById", summary="Add or update group project", description="Add or update project in group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="Successful update response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessfulUpdate.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=SuccessfulUpdate.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/groups/{group_id}/projects/{project_id}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    default public ResponseEntity<SuccessfulUpdate> addProjectToGroupById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="project_id", description="Project identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_id") @Min(value=0L) Long projectId, @Parameter(name="AddProjectToGroupByIdRequest", description="") @Valid @RequestBody(required=false) AddProjectToGroupByIdRequest addProjectToGroupByIdRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="addUserToGroupById", summary="Add group user", description="Add user into group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="Successful update response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessfulUpdate.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=SuccessfulUpdate.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/groups/{group_id}/users/{user_id}"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<SuccessfulUpdate> addUserToGroupById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="user_id", description="User identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") @Min(value=0L) Long userId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createGroup", summary="Create a group", description="Create a group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupInfo.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupInfo.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/groups"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    default public ResponseEntity<GroupInfo> createGroup(@Parameter(name="CreateGroupRequest", description="", required=true) @Valid @RequestBody CreateGroupRequest createGroupRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteGroup", summary="Delete group", description="Delete a group by ID.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/groups/{group_id}"}, produces={"application/problem+json"})
    default public ResponseEntity<Void> deleteGroup(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteProjectFromGroupById", summary="Delete group project", description="Delete project from group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/groups/{group_id}/projects/{project_id}"}, produces={"application/problem+json"})
    default public ResponseEntity<Void> deleteProjectFromGroupById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="project_id", description="Project identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_id") @Min(value=0L) Long projectId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteUserFromGroupById", summary="Delete group user", description="Delete a user from a group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/groups/{group_id}/users/{user_id}"}, produces={"application/problem+json"})
    default public ResponseEntity<Void> deleteUserFromGroupById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="user_id", description="User identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") @Min(value=0L) Long userId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupById", summary="Get group", description="Get a group by ID.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupInfo.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupInfo.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{group_id}"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupInfo> getGroupById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupProjectById", summary="Get group project", description="Get project of group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupProjectInfo.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupProjectInfo.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{group_id}/projects/{project_id}"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupProjectInfo> getGroupProjectById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="project_id", description="Project identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="project_id") @Min(value=0L) Long projectId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupProjects", summary="Get all group projects", description="Get all projects of group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupProjectsPage.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupProjectsPage.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{group_id}/projects"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupProjectsPage> getGroupProjects(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Parameter(name="offset", description="The offset used for this page of results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The limit used for this page of results. This will be the same as the limit query parameter unless it exceeded the maximum value allowed for this API endpoint.", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false, defaultValue="300") @Min(value=0L) @Max(value=1000L) @Valid Integer limit) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupUserById", summary="Get group user", description="Get all users of group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupUserInfo.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupUserInfo.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{group_id}/users/{user_id}"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupUserInfo> getGroupUserById(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Min(value=0L) @Parameter(name="user_id", description="User identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") @Min(value=0L) Long userId) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroupUsers", summary="Get all group users", description="Get all users of group.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupUsersPage.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupUsersPage.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups/{group_id}/users"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupUsersPage> getGroupUsers(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Parameter(name="offset", description="The offset used for this page of results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The limit used for this page of results. This will be the same as the limit query parameter unless it exceeded the maximum value allowed for this API endpoint.", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false, defaultValue="300") @Min(value=0L) @Max(value=1000L) @Valid Integer limit) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getGroups", summary="Get all groups", description="Get instance groups with optional filtering and sorting.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupPage.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=GroupPage.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/groups"}, produces={"application/json", "application/problem+json"})
    default public ResponseEntity<GroupPage> getGroups(@Parameter(name="offset", description="The offset used for this page of results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The limit used for this page of results. This will be the same as the limit query parameter unless it exceeded the maximum value allowed for this API endpoint.", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false, defaultValue="300") @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Parameter(name="order", description="Indicate sorting direction.", in=ParameterIn.QUERY) @Valid @RequestParam(value="order", required=false, defaultValue="ASC") String order, @Parameter(name="sort", description="Indicate sort by field.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false, defaultValue="name") String sort) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateGroup", summary="Update group", description="Update a group by ID.  ### Authority  - `ADMINISTRATOR`", tags={"Groups"}, responses={@ApiResponse(responseCode="200", description="Successful update response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessfulUpdate.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=SuccessfulUpdate.class))}), @ApiResponse(responseCode="400", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="402", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Error problem response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class)), @Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/groups/{group_id}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    default public ResponseEntity<SuccessfulUpdate> updateGroup(@Min(value=0L) @Parameter(name="group_id", description="Group identifier.", required=true, in=ParameterIn.PATH) @PathVariable(value="group_id") @Min(value=0L) Long groupId, @Parameter(name="UpdateGroupRequest", description="", required=true) @Valid @RequestBody UpdateGroupRequest updateGroupRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

