/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.ws.model.activity.IntegrationActivityResource;
import com.epam.ta.reportportal.ws.model.integration.AuthFlowEnum;
import com.epam.ta.reportportal.ws.model.integration.IntegrationResource;
import com.epam.ta.reportportal.ws.model.integration.IntegrationTypeResource;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;

public final class IntegrationConverter {
    private static final String ACCESS_TOKEN = "accessToken";
    public static final Function<Integration, IntegrationResource> TO_INTEGRATION_RESOURCE = integration -> {
        IntegrationResource resource = new IntegrationResource();
        resource.setId(integration.getId());
        resource.setName(integration.getName());
        resource.setCreator(integration.getCreator());
        resource.setCreationDate((Date)EntityUtils.TO_DATE.apply(integration.getCreationDate()));
        resource.setEnabled(Boolean.valueOf(integration.isEnabled()));
        Optional.ofNullable(integration.getProject()).ifPresent(p -> resource.setProjectId(p.getId()));
        Optional.ofNullable(integration.getParams()).ifPresent(it -> {
            HashMap params = new HashMap();
            Optional.ofNullable(it.getParams()).ifPresent(p -> p.entrySet().stream().filter(entry -> !EmailSettingsEnum.PASSWORD.getAttribute().equalsIgnoreCase((String)entry.getKey())).filter(entry -> !ACCESS_TOKEN.equalsIgnoreCase((String)entry.getKey())).forEach(param -> params.put(param.getKey(), param.getValue())));
            resource.setIntegrationParams(params);
        });
        IntegrationTypeResource type = new IntegrationTypeResource();
        type.setId(integration.getType().getId());
        type.setName(integration.getType().getName());
        type.setEnabled(integration.getType().isEnabled());
        type.setCreationDate((Date)EntityUtils.TO_DATE.apply(integration.getType().getCreationDate()));
        type.setGroupType(integration.getType().getIntegrationGroup().name());
        Optional.ofNullable(integration.getType().getDetails()).ifPresent(it -> type.setDetails(it.getDetails()));
        Optional.ofNullable(integration.getType().getAuthFlow()).ifPresent(it -> type.setAuthFlow(AuthFlowEnum.valueOf((String)it.name())));
        resource.setIntegrationType(type);
        return resource;
    };
    public static final Function<Integration, IntegrationActivityResource> TO_ACTIVITY_RESOURCE = integration -> {
        IntegrationActivityResource resource = new IntegrationActivityResource();
        resource.setId(integration.getId());
        Optional.ofNullable(integration.getProject()).ifPresent(p -> {
            resource.setProjectId(p.getId());
            resource.setProjectName(p.getName());
        });
        resource.setTypeName(integration.getType().getName());
        return resource;
    };

    private IntegrationConverter() {
    }
}

