/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.MergeLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LaunchLinkGenerator;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/{projectName}/launch"})
public class LaunchAsyncController {
    private final StartLaunchHandler startLaunchHandler;
    private final FinishLaunchHandler finishLaunchHandler;
    private final MergeLaunchHandler mergeLaunchesHandler;

    @Autowired
    public LaunchAsyncController(@Qualifier(value="startLaunchHandlerAsync") StartLaunchHandler startLaunchHandler, @Qualifier(value="finishLaunchHandlerAsync") FinishLaunchHandler finishLaunchHandler, MergeLaunchHandler mergeLaunchesHandler) {
        this.startLaunchHandler = startLaunchHandler;
        this.finishLaunchHandler = finishLaunchHandler;
        this.mergeLaunchesHandler = mergeLaunchesHandler;
    }

    @HttpLogging
    @PostMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Starts launch for specified project")
    public StartLaunchRS startLaunch(@PathVariable String projectName, @ApiParam(value="Start launch request body", required=true) @RequestBody @Validated StartLaunchRQ startLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.startLaunchHandler.startLaunch(user, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), startLaunchRQ);
    }

    @HttpLogging
    @PutMapping(value={"/{launchId}/finish"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish launch for specified project")
    public FinishLaunchRS finishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishLaunchRQ, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.finishLaunchHandler.finishLaunch(launchId, finishLaunchRQ, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LaunchLinkGenerator.composeBaseUrl(request.getScheme(), request.getHeader("host")));
    }

    @HttpLogging
    @Transactional
    @PostMapping(value={"/merge"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Merge set of specified launches in common one")
    public LaunchResource mergeLaunches(@PathVariable String projectName, @ApiParam(value="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.mergeLaunchesHandler.mergeLaunches(ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
    }
}

