/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.bts.handler.CreateTicketHandler;
import com.epam.ta.reportportal.core.bts.handler.GetTicketHandler;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.ws.model.externalsystem.PostTicketRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bts"})
public class BugTrackingSystemController {
    private final CreateTicketHandler createTicketHandler;
    private final GetTicketHandler getTicketHandler;

    @Autowired
    public BugTrackingSystemController(CreateTicketHandler createTicketHandler, GetTicketHandler getTicketHandler) {
        this.createTicketHandler = createTicketHandler;
        this.getTicketHandler = getTicketHandler;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/{integrationId}/fields-set"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of fields required for posting ticket")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    public List<PostFormField> getSetOfIntegrationSystemFields(@RequestParam(value="issueType") String issuetype, @PathVariable String projectName, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getTicketHandler.getSubmitTicketFields(issuetype, integrationId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/{integrationId}/issue_types"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of allowable issue types for bug tracking system")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    public List<String> getAllowableIssueTypes(@PathVariable String projectName, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getTicketHandler.getAllowableIssueTypes(integrationId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{integrationId}/fields-set"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of fields required for posting ticket")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public List<PostFormField> getSetOfIntegrationSystemFields(@RequestParam(value="issueType") String issueType, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getTicketHandler.getSubmitTicketFields(issueType, integrationId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{integrationId}/issue_types"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of fields required for posting ticket")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public List<String> getAllowableIssueTypes(@PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getTicketHandler.getAllowableIssueTypes(integrationId);
    }

    @Transactional
    @PostMapping(value={"/{projectName}/{integrationId}/ticket"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Post ticket to the bts integration")
    public Ticket createIssue(@Validated @RequestBody PostTicketRQ ticketRQ, @PathVariable String projectName, @PathVariable Long integrationId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createTicketHandler.createIssue(ticketRQ, integrationId, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/ticket/{ticketId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get ticket from the bts integration")
    public Ticket getTicket(@PathVariable String ticketId, @PathVariable String projectName, @RequestParam(value="btsUrl") String btsUrl, @RequestParam(value="btsProject") String btsProject, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getTicketHandler.getTicket(ticketId, btsUrl, btsProject, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }
}

