/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.util.UserUtils;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.UrlEscapers;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailService
extends JavaMailSenderImpl {
    private static final String FINISH_LAUNCH_EMAIL_SUBJECT = " Report Portal Notification: [%s] launch '%s' #%s finished";
    private static final String URL_FORMAT = "%s/launches/all";
    private static final String FULL_ATTRIBUTE_FILTER_FORMAT = "%s?filter.has.key=%s&filter.has.value=%s";
    private static final String VALUE_ATTRIBUTE_FILTER_FORMAT = "%s?filter.has.value=%s";
    private static final String EMAIL_TEMPLATE_PREFIX = "templates/email/";
    private TemplateEngine templateEngine;
    private String from;

    public EmailService(Properties javaMailProperties) {
        super.setJavaMailProperties(javaMailProperties);
    }

    public void sendCreateUserConfirmationEmail(String subject, String[] recipients, String url) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", url);
            String text = this.templateEngine.merge("registration-template.ftl", email);
            message.setText(text, true);
            message.addInline("create-user.png", (Resource)this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendLaunchFinishNotification(String[] recipients, String url, Project project, Launch launch) {
        String subject = String.format(FINISH_LAUNCH_EMAIL_SUBJECT, project.getName().toUpperCase(), launch.getName(), launch.getNumber());
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            String text = this.mergeFinishLaunchText(url, launch, project.getProjectIssueTypes());
            message.setText(text, true);
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    @VisibleForTesting
    String mergeFinishLaunchText(String url, Launch launch, Set<ProjectIssueType> projectIssueTypes) {
        HashMap<String, Object> email = new HashMap<String, Object>();
        String basicUrl = String.format(URL_FORMAT, url);
        email.put("name", launch.getName());
        email.put("number", String.valueOf(launch.getNumber()));
        email.put("description", launch.getDescription());
        email.put("url", String.format("%s/%s", basicUrl, launch.getId()));
        if (!CollectionUtils.isEmpty((Collection)launch.getAttributes())) {
            email.put("attributes", launch.getAttributes().stream().filter(it -> it.isSystem() == false).collect(Collectors.toMap(attribute -> Optional.ofNullable(attribute.getKey()).map(it -> it.concat(":")).orElse("").concat(attribute.getValue()), attribute -> this.buildAttributesLink(basicUrl, (ItemAttribute)attribute))));
        }
        Map<String, Integer> statistics = launch.getStatistics().stream().filter(s -> Optional.ofNullable(s.getStatisticsField()).isPresent() && StringUtils.isNotEmpty((CharSequence)s.getStatisticsField().getName())).collect(Collectors.toMap(s -> s.getStatisticsField().getName(), Statistics::getCounter, (prev, curr) -> prev));
        email.put("total", Optional.ofNullable(statistics.get("statistics$executions$total")).orElse(0));
        email.put("passed", Optional.ofNullable(statistics.get("statistics$executions$passed")).orElse(0));
        email.put("failed", Optional.ofNullable(statistics.get("statistics$executions$failed")).orElse(0));
        email.put("skipped", Optional.ofNullable(statistics.get("statistics$executions$skipped")).orElse(0));
        email.put("productBugTotal", Optional.ofNullable(statistics.get("statistics$defects$product_bug$total")).orElse(0));
        email.put("automationBugTotal", Optional.ofNullable(statistics.get("statistics$defects$automation_bug$total")).orElse(0));
        email.put("systemIssueTotal", Optional.ofNullable(statistics.get("statistics$defects$system_issue$total")).orElse(0));
        email.put("noDefectTotal", Optional.ofNullable(statistics.get("statistics$defects$no_defect$total")).orElse(0));
        email.put("toInvestigateTotal", Optional.ofNullable(statistics.get("statistics$defects$to_investigate$total")).orElse(0));
        Map<String, String> locatorsMapping = projectIssueTypes.stream().collect(Collectors.toMap(it -> it.getIssueType().getLocator(), it -> it.getIssueType().getLongName()));
        this.fillEmail(email, "pbInfo", statistics, locatorsMapping, "^statistics\\$defects\\$product_bug\\$((?!total$).)+.*$");
        this.fillEmail(email, "abInfo", statistics, locatorsMapping, "^statistics\\$defects\\$automation_bug\\$((?!total$).)+.*$");
        this.fillEmail(email, "siInfo", statistics, locatorsMapping, "^statistics\\$defects\\$system_issue\\$((?!total$).)+.*$");
        this.fillEmail(email, "ndInfo", statistics, locatorsMapping, "^statistics\\$defects\\$no_defect\\$((?!total$).)+.*$");
        this.fillEmail(email, "tiInfo", statistics, locatorsMapping, "^statistics\\$defects\\$to_investigate\\$((?!total$).)+.*$");
        return this.templateEngine.merge("finish-launch-template.ftl", email);
    }

    private String buildAttributesLink(String basicUrl, ItemAttribute attribute) {
        if (null != attribute.getKey()) {
            return String.format(FULL_ATTRIBUTE_FILTER_FORMAT, basicUrl, UrlEscapers.urlPathSegmentEscaper().escape(attribute.getKey()), UrlEscapers.urlPathSegmentEscaper().escape(attribute.getValue()));
        }
        return String.format(VALUE_ATTRIBUTE_FILTER_FORMAT, basicUrl, UrlEscapers.urlPathSegmentEscaper().escape(attribute.getValue()));
    }

    private void fillEmail(Map<String, Object> email, String statisticsName, Map<String, Integer> statistics, Map<String, String> locatorsMapping, String regex) {
        Optional<Map<String, Integer>> pb = Optional.of(statistics.entrySet().stream().filter(entry -> {
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher((CharSequence)entry.getKey()).matches();
        }).collect(Collectors.toMap(entry -> (String)locatorsMapping.get(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"$")), entry -> Optional.ofNullable(entry.getValue()).orElse(0), (prev, curr) -> prev)));
        pb.ifPresent(stats -> email.put(statisticsName, stats));
    }

    public void sendRestorePasswordEmail(String subject, String[] recipients, String url, String login) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("login", login);
            email.put("url", url);
            String text = this.templateEngine.merge("restore-password-template.ftl", email);
            message.setText(text, true);
            message.addInline("restore-password.png", (Resource)this.emailTemplateResource("restore-password.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendIndexFinishedEmail(String subject, String recipient, Long indexedLogsCount) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipient);
            HashMap<String, Long> email = new HashMap<String, Long>();
            email.put("indexedLogsCount", Optional.ofNullable(indexedLogsCount).orElse(0L));
            this.setFrom(message);
            String text = this.templateEngine.merge("index-finished-template.ftl", email);
            message.setText(text, true);
        };
        this.send(preparator);
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void sendCreateUserConfirmationEmail(CreateUserRQFull req, String basicUrl) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Welcome to Report Portal");
            message.setTo(req.getEmail());
            this.setFrom(message);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", basicUrl);
            email.put("login", EntityUtils.normalizeId((String)req.getLogin()));
            email.put("password", req.getPassword());
            String text = this.templateEngine.merge("create-user-template.ftl", email);
            message.setText(text, true);
            message.addInline("create-user.png", (Resource)this.emailTemplateResource("create-user.png"));
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    public void sendConnectionTestEmail(String sendTo) {
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Email server integration creation");
            message.setTo(sendTo);
            this.setFrom(message);
            Map data = Collections.emptyMap();
            String text = this.templateEngine.merge("email-connection.ftl", data);
            message.setText(text, true);
            this.attachSocialImages(message);
        };
        this.send(preparator);
    }

    private void setFrom(MimeMessageHelper message) throws MessagingException, UnsupportedEncodingException {
        if (StringUtils.isNotBlank((CharSequence)this.from)) {
            if (UserUtils.isEmailValid((String)this.from) && this.isAddressValid(this.from)) {
                message.setFrom(this.from);
            } else if (UserUtils.isEmailValid((String)this.getUsername())) {
                message.setFrom(this.getUsername(), this.from);
            }
        } else if (UserUtils.isEmailValid((String)this.getUsername())) {
            message.setFrom(this.getUsername());
        }
    }

    private boolean isAddressValid(String from) {
        try {
            InternetAddress.parse((String)from);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    private void attachSocialImages(MimeMessageHelper message) throws MessagingException {
        message.addInline("ic-github.png", (Resource)this.emailTemplateResource("ic-github.png"));
        message.addInline("ic-fb.png", (Resource)this.emailTemplateResource("ic-fb.png"));
        message.addInline("ic-twitter.png", (Resource)this.emailTemplateResource("ic-twitter.png"));
        message.addInline("ic-youtube.png", (Resource)this.emailTemplateResource("ic-youtube.png"));
        message.addInline("ic-vk.png", (Resource)this.emailTemplateResource("ic-vk.png"));
        message.addInline("ic-slack.png", (Resource)this.emailTemplateResource("ic-slack.png"));
    }

    private ClassPathResource emailTemplateResource(String resource) {
        return new ClassPathResource(EMAIL_TEMPLATE_PREFIX + resource);
    }
}

