/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.store.service;

import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerSettingsService {
    private final ServerSettingsRepository serverSettingsRepository;

    @Autowired
    public ServerSettingsService(ServerSettingsRepository serverSettingsRepository) {
        this.serverSettingsRepository = serverSettingsRepository;
    }

    public Map<String, String> findAllSettings() {
        return this.serverSettingsRepository.streamAll().collect(Collectors.toMap(ServerSettings::getKey, s -> Optional.ofNullable(s.getValue()).orElse("")));
    }

    public void save(Map<String, String> settings) {
        settings.entrySet().stream().map(entry -> new ServerSettings((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).forEach(ss -> {
            Optional prop = this.serverSettingsRepository.findByKey(ss.getKey());
            if (prop.isPresent()) {
                ServerSettings setting = (ServerSettings)prop.get();
                setting.setValue(ss.getValue());
                this.serverSettingsRepository.save((Object)setting);
            } else {
                this.serverSettingsRepository.save((Object)new ServerSettings(ss.getKey(), ss.getValue()));
            }
        });
    }

    public void save(Object o) {
    }
}

