/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.filesystem.DataStore;
import com.epam.ta.reportportal.job.PluginLoaderService;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Conditional(value={Conditions.NotTestCondition.class})
@Service
public class LoadPluginsJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadPluginsJob.class);
    private final IntegrationTypeRepository integrationTypeRepository;
    private final PluginLoaderService pluginLoaderService;
    private final String pluginsRootPath;
    private final Pf4jPluginBox pluginBox;
    private final DataStore dataStore;

    @Autowired
    public LoadPluginsJob(@Value(value="${rp.plugins.path}") String pluginsRootPath, IntegrationTypeRepository integrationTypeRepository, PluginLoaderService pluginLoaderService, Pf4jPluginBox pf4jPluginBox, DataStore dataStore) {
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginLoaderService = pluginLoaderService;
        this.pluginBox = pf4jPluginBox;
        this.dataStore = dataStore;
        this.pluginsRootPath = pluginsRootPath;
    }

    @Scheduled(fixedDelayString="${com.ta.reportportal.job.load.plugins.cron}")
    public void execute() {
        List integrationTypes = this.integrationTypeRepository.findAll();
        List<PluginInfo> notLoadedPlugins = this.pluginLoaderService.getNotLoadedPluginsInfo(integrationTypes);
        notLoadedPlugins.forEach(pluginInfo -> Optional.ofNullable(this.dataStore.load(pluginInfo.getFileId())).ifPresent(inputStream -> {
            try {
                LOGGER.debug("Plugin loading has started...");
                if (!Files.exists(Paths.get(this.pluginsRootPath, pluginInfo.getFileName()), new LinkOption[0])) {
                    LOGGER.debug("Copying plugin file...");
                    FileUtils.copyToFile((InputStream)inputStream, (File)new File(this.pluginsRootPath, pluginInfo.getFileName()));
                }
                if (pluginInfo.isEnabled()) {
                    IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginInfo.getId()).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginInfo.getId()}));
                    boolean isLoaded = this.pluginBox.loadPlugin(integrationType.getName(), integrationType.getDetails());
                    if (isLoaded) {
                        LOGGER.debug((String)Suppliers.formattedSupplier((String)"Plugin - '{}' has been successfully started.", (Object[])new Object[]{integrationType.getName()}).get());
                    } else {
                        LOGGER.error((String)Suppliers.formattedSupplier((String)"Plugin - '{}' has not been started.", (Object[])new Object[]{integrationType.getName()}).get());
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error has occurred during plugin copying from the Data store", (Throwable)ex);
            }
        }));
    }
}

